/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.frame.XModel;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.languagetool.JLanguageTool;
import org.languagetool.gui.Configuration;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.IgnoredMatches;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.ResultCache;

public class CacheIO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG_MODE = OfficeTools.DEBUG_MODE_IO;
    private static final long MAX_CACHE_TIME = 1471228928L;
    private static final String CACHEFILE_MAP = "LtCacheMap";
    private static final String CACHEFILE_PREFIX = "LtCache";
    private static final String CACHEFILE_EXTENSION = "lcz";
    private static final int MIN_CHARACTERS_TO_SAVE_CACHE = 25000;
    private static final String SPELL_CACHEFILE = "LtSpellCache.lcz";
    private String documentPath = null;
    private AllCaches allCaches;

    CacheIO(XComponent xComponent) {
        this.setDocumentPath(xComponent);
    }

    CacheIO() {
    }

    void setDocumentPath(XComponent xComponent) {
        if (xComponent != null) {
            this.documentPath = CacheIO.getDocumentPath(xComponent);
        }
    }

    private static String getDocumentPath(XComponent xComponent) {
        try {
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            if (xModel == null) {
                MessageHandler.printToLogFile("CacheIO: getDocumentPath: XModel not found!");
                return null;
            }
            String url = xModel.getURL();
            if (url == null || !url.startsWith("file://")) {
                if (url != null && !url.isEmpty()) {
                    MessageHandler.printToLogFile("Not a file URL: " + (url == null ? "null" : url));
                }
                return null;
            }
            if (DEBUG_MODE) {
                MessageHandler.printToLogFile("CacheIO: getDocumentPath: file URL: " + url);
            }
            URI uri = new URI(url);
            return uri.getPath();
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    private String getCachePath(boolean create) {
        CacheFile cacheFile;
        String cacheFileName;
        if (this.documentPath == null) {
            MessageHandler.printToLogFile("CacheIO: getCachePath: documentPath == null!");
            return null;
        }
        File cacheDir = OfficeTools.getCacheDir();
        if (cacheDir == null) {
            MessageHandler.printToLogFile("CacheIO: getCachePath: cacheDir == null!");
            return null;
        }
        if (DEBUG_MODE) {
            MessageHandler.printToLogFile("CacheIO: getCachePath: cacheDir: " + cacheDir.getAbsolutePath());
        }
        if ((cacheFileName = (cacheFile = new CacheFile(cacheDir)).getCacheFileName(this.documentPath, create)) == null) {
            MessageHandler.printToLogFile("CacheIO: getCachePath: cacheFileName == null!");
            return null;
        }
        File cacheFilePath = new File(cacheDir, cacheFileName);
        if (!create) {
            cacheFile.cleanUp(cacheFileName);
        }
        if (DEBUG_MODE) {
            MessageHandler.printToLogFile("CacheIO: getCachePath: cacheFilePath: " + cacheFilePath.getAbsolutePath());
        }
        return cacheFilePath.getAbsolutePath();
    }

    private void saveAllCaches(String cachePath) {
        try {
            GZIPOutputStream fileOut = new GZIPOutputStream(new FileOutputStream(cachePath));
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(this.allCaches);
            out.close();
            fileOut.close();
            MessageHandler.printToLogFile("Caches saved to: " + cachePath);
            if (DEBUG_MODE) {
                this.printCacheInfo();
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
    }

    private boolean exceedsSaveSize(DocumentCache docCache) {
        int nChars = 0;
        for (int i = 0; i < docCache.size(); ++i) {
            if ((nChars += docCache.getFlatParagraph(i).length()) <= 25000) continue;
            return true;
        }
        return false;
    }

    public void saveCaches(DocumentCache docCache, List<ResultCache> paragraphsCache, IgnoredMatches ignoredMatches, Configuration config, MultiDocumentsHandler mDocHandler) {
        block6: {
            String cachePath = this.getCachePath(true);
            if (cachePath != null) {
                try {
                    if (!ignoredMatches.isEmpty() || this.exceedsSaveSize(docCache)) {
                        this.allCaches = new AllCaches(docCache, paragraphsCache, mDocHandler.getAllDisabledRules(), config.getDisabledRuleIds(), config.getDisabledCategoryNames(), config.getEnabledRuleIds(), ignoredMatches, JLanguageTool.VERSION);
                        this.saveAllCaches(cachePath);
                    } else {
                        File file = new File(cachePath);
                        if (file.exists() && !file.isDirectory()) {
                            file.delete();
                        }
                    }
                }
                catch (Throwable t) {
                    MessageHandler.printToLogFile("CacheIO: saveCaches: " + t.getMessage());
                    if (!DEBUG_MODE) break block6;
                    MessageHandler.printException(t);
                }
            }
        }
    }

    public boolean readAllCaches(Configuration config, MultiDocumentsHandler mDocHandler) {
        String cachePath = this.getCachePath(false);
        if (cachePath == null) {
            return false;
        }
        try {
            File file = new File(cachePath);
            if (file.exists() && !file.isDirectory()) {
                GZIPInputStream fileIn = new GZIPInputStream(new FileInputStream(file));
                ObjectInputStream in = new ObjectInputStream(fileIn);
                this.allCaches = (AllCaches)in.readObject();
                in.close();
                fileIn.close();
                MessageHandler.printToLogFile("Caches read from: " + cachePath);
                if (DEBUG_MODE) {
                    this.printCacheInfo();
                }
                if (this.runSameRules(config, mDocHandler)) {
                    return true;
                }
                MessageHandler.printToLogFile("Version or active rules have changed: Cache rejected (Cache Version: " + this.allCaches.ltVersion + ", actual LT Version: " + JLanguageTool.VERSION + ")");
                return false;
            }
        }
        catch (InvalidClassException e) {
            MessageHandler.printToLogFile("Old cache Version: Cache not read");
            return false;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        return false;
    }

    private boolean runSameRules(Configuration config, MultiDocumentsHandler mDocHandler) {
        if (this.allCaches == null || this.allCaches.docCache == null || this.allCaches.docCache.toParaMapping.size() != 6) {
            if (DEBUG_MODE) {
                MessageHandler.printToLogFile("allCaches == null: " + (this.allCaches == null) + "; allCaches.docCache == null: " + (this.allCaches.docCache == null) + "; allCaches.docCache.toTextMapping.size(): " + this.allCaches.docCache.toParaMapping.size());
            }
            return false;
        }
        if (!this.allCaches.ltVersion.equals(JLanguageTool.VERSION)) {
            return false;
        }
        if (config.getEnabledRuleIds().size() != this.allCaches.enabledRuleIds.size() || config.getDisabledRuleIds().size() != this.allCaches.disabledRuleIds.size() || config.getDisabledCategoryNames().size() != this.allCaches.disabledCategories.size()) {
            if (DEBUG_MODE) {
                MessageHandler.printToLogFile("config.getEnabledRuleIds().size() " + config.getEnabledRuleIds().size() + "; allCaches.enabledRuleIds.size(): " + this.allCaches.enabledRuleIds.size() + "\n config.getDisabledRuleIds().size(): " + config.getDisabledRuleIds().size() + "; allCaches.disabledRuleIds.size(): " + this.allCaches.disabledRuleIds.size() + "\n config.getDisabledCategoryNames().size(): " + config.getDisabledCategoryNames().size() + "; allCaches.disabledCategories.size(): " + this.allCaches.disabledCategories.size());
            }
            return false;
        }
        for (String ruleId : config.getEnabledRuleIds()) {
            if (this.allCaches.enabledRuleIds.contains(ruleId)) continue;
            return false;
        }
        for (String category : config.getDisabledCategoryNames()) {
            if (this.allCaches.disabledCategories.contains(category)) continue;
            return false;
        }
        HashSet<String> disabledRuleIds = new HashSet<String>(config.getDisabledRuleIds());
        String langCode = OfficeTools.localeToString(mDocHandler.getLocale());
        for (String ruleId : mDocHandler.getDisabledRules(langCode)) {
            disabledRuleIds.add(ruleId);
        }
        if (disabledRuleIds.size() != this.allCaches.disabledRuleIds.size()) {
            return false;
        }
        for (String ruleId : disabledRuleIds) {
            if (this.allCaches.disabledRuleIds.contains(ruleId)) continue;
            return false;
        }
        HashMap<String, Set<String>> disabledRulesUI = new HashMap<String, Set<String>>();
        for (String lang : this.allCaches.disabledRulesUI.keySet()) {
            HashSet<String> ruleIDs = new HashSet<String>();
            for (String ruleID : this.allCaches.disabledRulesUI.get(lang)) {
                ruleIDs.add(ruleID);
            }
            disabledRulesUI.put(langCode, ruleIDs);
        }
        mDocHandler.setAllDisabledRules(disabledRulesUI);
        return true;
    }

    public DocumentCache getDocumentCache() {
        return this.allCaches.docCache;
    }

    public List<ResultCache> getParagraphsCache() {
        return this.allCaches.paragraphsCache;
    }

    public IgnoredMatches getIgnoredMatches() {
        HashMap<Integer, Map<String, Set<Integer>>> ignoredMatches = new HashMap<Integer, Map<String, Set<Integer>>>();
        for (int y : this.allCaches.ignoredMatches.keySet()) {
            HashMap newIdMap = new HashMap();
            HashMap<String, Set<Integer>> idMap = new HashMap<String, Set<Integer>>(this.allCaches.ignoredMatches.get(y));
            for (String id : idMap.keySet()) {
                HashSet xSet = new HashSet((Collection)idMap.get(id));
                newIdMap.put(id, xSet);
            }
            ignoredMatches.put(y, newIdMap);
        }
        HashMap<Integer, List<IgnoredMatches.LocaleEntry>> sLocales = new HashMap<Integer, List<IgnoredMatches.LocaleEntry>>();
        MessageHandler.printToLogFile("CacheIO: getIgnoredMatches: spellLocales: size: " + this.allCaches.spellLocales.size());
        for (int y : this.allCaches.spellLocales.keySet()) {
            ArrayList<IgnoredMatches.LocaleEntry> newEntryList = new ArrayList<IgnoredMatches.LocaleEntry>();
            ArrayList locEntries = new ArrayList(this.allCaches.spellLocales.get(y));
            MessageHandler.printToLogFile("CacheIO: getIgnoredMatches: spellLocales: size: " + locEntries.size() + " at y: " + y);
            for (LocaleSerialEntry entry : locEntries) {
                newEntryList.add(new IgnoredMatches.LocaleEntry(entry.start, entry.length, entry.locale.toLocale(), entry.ruleId));
            }
            sLocales.put(y, newEntryList);
        }
        return new IgnoredMatches(ignoredMatches, sLocales);
    }

    public void resetAllCache() {
        this.allCaches = null;
    }

    private void printCacheInfo() {
        int n;
        MessageHandler.printToLogFile("CacheIO: saveCaches:");
        MessageHandler.printToLogFile("Document Cache: Number of paragraphs: " + this.allCaches.docCache.size());
        MessageHandler.printToLogFile("Paragraph Cache(0): Number of paragraphs: " + this.allCaches.paragraphsCache.get(0).getNumberOfParas() + ", Number of matches: " + this.allCaches.paragraphsCache.get(0).getNumberOfMatches());
        MessageHandler.printToLogFile("Paragraph Cache(1): Number of paragraphs: " + this.allCaches.paragraphsCache.get(1).getNumberOfParas() + ", Number of matches: " + this.allCaches.paragraphsCache.get(1).getNumberOfMatches());
        for (n = 0; n < this.allCaches.docCache.size(); ++n) {
            MessageHandler.printToLogFile("allCaches.docCache.getFlatParagraphLocale(" + n + "): " + (this.allCaches.docCache.getFlatParagraphLocale(n) == null ? "null" : OfficeTools.localeToString(this.allCaches.docCache.getFlatParagraphLocale(n))));
        }
        if (this.allCaches.paragraphsCache.get(0) == null) {
            MessageHandler.printToLogFile("paragraphsCache(0) == null");
        } else if (this.allCaches.paragraphsCache.get(0).getNumberOfMatches() > 0) {
            for (n = 0; n < this.allCaches.paragraphsCache.get(0).getNumberOfParas(); ++n) {
                if (this.allCaches.paragraphsCache.get(0).getMatches(n, OfficeTools.LoErrorType.BOTH) == null) {
                    MessageHandler.printToLogFile("allCaches.sentencesCache.getMatches(" + n + ") == null");
                    continue;
                }
                if (this.allCaches.paragraphsCache.get(0).getMatches(n, OfficeTools.LoErrorType.BOTH).length <= 0) continue;
                MessageHandler.printToLogFile("Paragraph " + n + " sentence match[0]: nStart = " + this.allCaches.paragraphsCache.get((int)0).getMatches((int)n, (OfficeTools.LoErrorType)OfficeTools.LoErrorType.BOTH)[0].nErrorStart + ", nLength = " + this.allCaches.paragraphsCache.get((int)0).getMatches((int)n, (OfficeTools.LoErrorType)OfficeTools.LoErrorType.BOTH)[0].nErrorLength + ", errorID = " + (this.allCaches.paragraphsCache.get((int)0).getMatches((int)n, (OfficeTools.LoErrorType)OfficeTools.LoErrorType.BOTH)[0].aRuleIdentifier == null ? "null" : this.allCaches.paragraphsCache.get((int)0).getMatches((int)n, (OfficeTools.LoErrorType)OfficeTools.LoErrorType.BOTH)[0].aRuleIdentifier));
            }
        }
    }

    public class SpellCache
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, List<String>> lastWrongWords = new HashMap<String, List<String>>();
        private final Map<String, List<String[]>> lastSuggestions = new HashMap<String, List<String[]>>();
        private String version = JLanguageTool.VERSION;

        private boolean putAll(SpellCache sc) {
            this.version = sc.version;
            if (!this.version.equals(JLanguageTool.VERSION)) {
                return false;
            }
            this.lastWrongWords.clear();
            this.lastWrongWords.putAll(sc.lastWrongWords);
            this.lastSuggestions.clear();
            this.lastSuggestions.putAll(sc.lastSuggestions);
            return true;
        }

        public void write(Map<String, List<String>> lastWrongWords, Map<String, List<String[]>> lastSuggestions) {
            this.lastWrongWords.clear();
            this.lastSuggestions.clear();
            this.lastWrongWords.putAll(lastWrongWords);
            this.lastSuggestions.putAll(lastSuggestions);
            try {
                File cacheDir = OfficeTools.getCacheDir();
                File cacheFilePath = new File(cacheDir, CacheIO.SPELL_CACHEFILE);
                String cachePath = cacheFilePath.getAbsolutePath();
                if (cachePath != null) {
                    GZIPOutputStream fileOut = new GZIPOutputStream(new FileOutputStream(cachePath));
                    ObjectOutputStream out = new ObjectOutputStream(fileOut);
                    out.writeObject(this);
                    out.close();
                    fileOut.close();
                    MessageHandler.printToLogFile("Spell Cache saved to: " + cachePath);
                }
            }
            catch (Throwable t) {
                MessageHandler.printException(t);
            }
        }

        public boolean read() {
            File cacheDir = OfficeTools.getCacheDir();
            File cacheFilePath = new File(cacheDir, CacheIO.SPELL_CACHEFILE);
            String cachePath = cacheFilePath.getAbsolutePath();
            if (cachePath == null) {
                return false;
            }
            try {
                File file = new File(cachePath);
                if (file.exists() && !file.isDirectory()) {
                    GZIPInputStream fileIn = new GZIPInputStream(new FileInputStream(file));
                    ObjectInputStream in = new ObjectInputStream(fileIn);
                    boolean out = this.putAll((SpellCache)in.readObject());
                    in.close();
                    fileIn.close();
                    MessageHandler.printToLogFile("Spell Cache read from: " + cachePath);
                    if (out) {
                        return true;
                    }
                    MessageHandler.printToLogFile("Version has changed: Spell Cache rejected (Cache Version: " + this.version + ", actual LT Version: " + JLanguageTool.VERSION + ")");
                    return false;
                }
            }
            catch (InvalidClassException e) {
                MessageHandler.printToLogFile("Old cache Version: Spell Cache not read");
                return false;
            }
            catch (Throwable t) {
                MessageHandler.printException(t);
            }
            return false;
        }

        public Map<String, List<String>> getWrongWords() {
            return this.lastWrongWords;
        }

        public Map<String, List<String[]>> getSuggestions() {
            return this.lastSuggestions;
        }
    }

    private class CacheFile
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private CacheMap cacheMap;
        private File cacheMapFile;

        CacheFile() {
            this(OfficeTools.getCacheDir());
        }

        CacheFile(File cacheDir) {
            this.cacheMapFile = new File(cacheDir, CacheIO.CACHEFILE_MAP);
            if (this.cacheMapFile != null) {
                if (this.cacheMapFile.exists() && !this.cacheMapFile.isDirectory() && this.read()) {
                    return;
                }
                this.cacheMap = new CacheMap();
                if (DEBUG_MODE) {
                    MessageHandler.printToLogFile("CacheIO: CacheFile: create cacheMap file");
                }
                this.write(this.cacheMap);
            }
        }

        public boolean read() {
            try {
                FileInputStream fileIn = new FileInputStream(this.cacheMapFile);
                ObjectInputStream in = new ObjectInputStream(fileIn);
                this.cacheMap = (CacheMap)in.readObject();
                if (DEBUG_MODE) {
                    MessageHandler.printToLogFile("CacheIO: CacheFile: read cacheMap file: size=" + this.cacheMap.size());
                }
                in.close();
                fileIn.close();
                return true;
            }
            catch (Throwable t) {
                MessageHandler.printException(t);
                return false;
            }
        }

        public void write(CacheMap cacheMap) {
            try {
                FileOutputStream fileOut = new FileOutputStream(this.cacheMapFile);
                ObjectOutputStream out = new ObjectOutputStream(fileOut);
                if (DEBUG_MODE) {
                    MessageHandler.printToLogFile("CacheIO: CacheFile: write cacheMap file: size=" + cacheMap.size());
                }
                out.writeObject(cacheMap);
                out.close();
                fileOut.close();
            }
            catch (Throwable t) {
                MessageHandler.printException(t);
            }
        }

        public String getCacheFileName(String docPath, boolean create) {
            if (this.cacheMap == null) {
                return null;
            }
            int orgSize = this.cacheMap.size();
            String cacheFileName = this.cacheMap.getOrCreateCacheFile(docPath, create);
            if (this.cacheMap.size() != orgSize) {
                this.write(this.cacheMap);
            }
            return cacheFileName;
        }

        public void cleanUp(String curCacheFile) {
            CacheCleanUp cacheCleanUp = new CacheCleanUp(this.cacheMap, curCacheFile);
            cacheCleanUp.start();
        }

        private class CacheCleanUp
        extends Thread
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private CacheMap cacheMap;
            private String currentFile;

            CacheCleanUp(CacheMap in, String curFile) {
                this.cacheMap = new CacheMap(in);
                this.currentFile = curFile;
            }

            @Override
            public void run() {
                try {
                    File[] cacheFiles;
                    long systemTime = System.currentTimeMillis();
                    boolean mapChanged = false;
                    File cacheDir = OfficeTools.getCacheDir();
                    ArrayList<String> mapedDocs = new ArrayList<String>();
                    for (String doc : this.cacheMap.keySet()) {
                        mapedDocs.add(doc);
                    }
                    for (String doc : mapedDocs) {
                        File docFile = new File(doc);
                        String cacheFileName = this.cacheMap.get(doc);
                        File cacheFile = new File(cacheDir, cacheFileName);
                        if (DEBUG_MODE) {
                            MessageHandler.printToLogFile("CacheIO: CacheCleanUp: CacheMap: docPath=" + doc + ", docFile exist: " + (docFile == null ? "null" : Boolean.valueOf(docFile.exists())) + ", cacheFile exist: " + (cacheFile == null ? "null" : Boolean.valueOf(cacheFile.exists())));
                        }
                        if (docFile != null && docFile.exists() && cacheFile != null && cacheFile.exists() && (systemTime - cacheFile.lastModified() <= 1471228928L || cacheFileName.equals(this.currentFile))) continue;
                        this.cacheMap.remove(doc);
                        mapChanged = true;
                        MessageHandler.printToLogFile("CacheIO: CacheCleanUp: Remove Path from CacheMap: " + doc);
                        if (cacheFile == null || !cacheFile.exists()) continue;
                        cacheFile.delete();
                        MessageHandler.printToLogFile("CacheIO: CacheCleanUp: Delete cache file: " + cacheFile.getAbsolutePath());
                    }
                    if (mapChanged) {
                        if (DEBUG_MODE) {
                            MessageHandler.printToLogFile("CacheIO: CacheCleanUp: Write CacheMap");
                        }
                        CacheFile.this.write(this.cacheMap);
                    }
                    if ((cacheFiles = cacheDir.listFiles()) != null) {
                        for (File cacheFile : cacheFiles) {
                            if (this.cacheMap.containsValue(cacheFile.getName()) || cacheFile.getName().equals(CacheIO.CACHEFILE_MAP) || cacheFile.getName().equals(CacheIO.SPELL_CACHEFILE)) continue;
                            cacheFile.delete();
                            MessageHandler.printToLogFile("Delete cache file: " + cacheFile.getAbsolutePath());
                        }
                    }
                }
                catch (Throwable t) {
                    MessageHandler.printException(t);
                }
            }
        }

        private class CacheMap
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private Map<String, String> cacheNames = new HashMap<String, String>();

            CacheMap() {
            }

            CacheMap(CacheMap in) {
                this.cacheNames.putAll(in.getCacheNames());
            }

            private Map<String, String> getCacheNames() {
                return this.cacheNames;
            }

            public int size() {
                return this.cacheNames.keySet().size();
            }

            public boolean containsValue(String value) {
                return this.cacheNames.containsValue(value);
            }

            public Set<String> keySet() {
                return this.cacheNames.keySet();
            }

            public String get(String key) {
                return this.cacheNames.get(key);
            }

            public String remove(String key) {
                return this.cacheNames.remove(key);
            }

            public String getOrCreateCacheFile(String docPath, boolean create) {
                if (DEBUG_MODE) {
                    MessageHandler.printToLogFile("CacheIO: getOrCreateCacheFile: docPath=" + docPath);
                    for (String file : this.cacheNames.keySet()) {
                        MessageHandler.printToLogFile("cacheNames: docPath=" + file + ", cache=" + this.cacheNames.get(file));
                    }
                }
                if (this.cacheNames.containsKey(docPath)) {
                    return this.cacheNames.get(docPath);
                }
                if (!create) {
                    return null;
                }
                int i = 1;
                String cacheName = CacheIO.CACHEFILE_PREFIX + i + "." + CacheIO.CACHEFILE_EXTENSION;
                while (this.cacheNames.containsValue(cacheName)) {
                    cacheName = CacheIO.CACHEFILE_PREFIX + ++i + "." + CacheIO.CACHEFILE_EXTENSION;
                }
                this.cacheNames.put(docPath, cacheName);
                return cacheName;
            }
        }
    }

    public class LocaleSerialEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int start;
        int length;
        DocumentCache.SerialLocale locale;
        String ruleId;

        LocaleSerialEntry(int start, int length, Locale locale, String ruleId) {
            this.start = start;
            this.length = length;
            this.locale = new DocumentCache.SerialLocale(locale);
            this.ruleId = new String(ruleId);
        }
    }

    class AllCaches
    implements Serializable {
        private static final long serialVersionUID = 6L;
        DocumentCache docCache;
        List<ResultCache> paragraphsCache;
        Map<String, List<String>> disabledRulesUI;
        List<String> disabledRuleIds;
        List<String> disabledCategories;
        List<String> enabledRuleIds;
        Map<Integer, Map<String, Set<Integer>>> ignoredMatches;
        Map<Integer, List<LocaleSerialEntry>> spellLocales;
        String ltVersion;

        AllCaches(DocumentCache docCache, List<ResultCache> paragraphsCache, Map<String, Set<String>> disabledRulesUI, Set<String> disabledRuleIds, Set<String> disabledCategories, Set<String> enabledRuleIds, IgnoredMatches ignoredMatches, String ltVersion) {
            this.docCache = docCache;
            this.paragraphsCache = paragraphsCache;
            this.disabledRulesUI = new HashMap<String, List<String>>();
            for (String string : disabledRulesUI.keySet()) {
                ArrayList<String> ruleIDs = new ArrayList<String>();
                for (String ruleID2 : disabledRulesUI.get(string)) {
                    ruleIDs.add(ruleID2);
                }
                this.disabledRulesUI.put(string, ruleIDs);
            }
            this.disabledRuleIds = new ArrayList<String>();
            for (String string : disabledRuleIds) {
                this.disabledRuleIds.add(string);
            }
            this.disabledCategories = new ArrayList<String>();
            for (String string : disabledCategories) {
                this.disabledCategories.add(string);
            }
            this.enabledRuleIds = new ArrayList<String>();
            for (String string : enabledRuleIds) {
                this.enabledRuleIds.add(string);
            }
            this.ltVersion = ltVersion;
            HashMap<Integer, Map<String, Set<Integer>>> clone = new HashMap<Integer, Map<String, Set<Integer>>>();
            for (int y : ignoredMatches.getFullIMMap().keySet()) {
                HashMap newIdMap = new HashMap();
                HashMap<String, Set<Integer>> idMap = new HashMap<String, Set<Integer>>(ignoredMatches.get(y));
                for (String id : idMap.keySet()) {
                    HashSet xSet = new HashSet((Collection)idMap.get(id));
                    newIdMap.put(id, xSet);
                }
                clone.put(y, newIdMap);
            }
            this.ignoredMatches = clone;
            HashMap<Integer, List<LocaleSerialEntry>> hashMap = new HashMap<Integer, List<LocaleSerialEntry>>();
            for (int y : ignoredMatches.getFullSLMap().keySet()) {
                ArrayList<LocaleSerialEntry> newEntryList = new ArrayList<LocaleSerialEntry>();
                ArrayList<IgnoredMatches.LocaleEntry> locEntries = new ArrayList<IgnoredMatches.LocaleEntry>(ignoredMatches.getLocaleEntries(y));
                MessageHandler.printToLogFile("CacheIO: AllCaches: spellLocales: size: " + locEntries.size() + " at y: " + y);
                for (IgnoredMatches.LocaleEntry entry : locEntries) {
                    newEntryList.add(new LocaleSerialEntry(entry.start, entry.length, entry.locale, entry.ruleId));
                }
                hashMap.put(y, newEntryList);
            }
            this.spellLocales = hashMap;
        }
    }
}

