/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.lang.Locale;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.json.JSONObject;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.SingleDocument;

public class AnalyzedParagraphsCache {
    private JSONObject doc;
    private String locale;

    AnalyzedParagraphsCache(MultiDocumentsHandler mDocHandler) {
        Locale tmpLocale;
        DocumentCache docCache;
        block10: {
            block9: {
                this.doc = new JSONObject();
                SingleDocument document = mDocHandler.getCurrentDocument();
                if (document == null) {
                    return;
                }
                docCache = document.getDocumentCache();
                if (docCache == null) {
                    return;
                }
                tmpLocale = docCache.getFlatParagraphLocale(0);
                if (tmpLocale == null) break block9;
                if (MultiDocumentsHandler.hasLocale(tmpLocale)) break block10;
            }
            this.locale = null;
            return;
        }
        this.locale = OfficeTools.localeToString(tmpLocale);
        Language language = Languages.getLanguageForShortCode(OfficeTools.localeToString(tmpLocale));
        JLanguageTool lt = new JLanguageTool(language);
        try {
            DocumentCache.TextParagraph tPara = new DocumentCache.TextParagraph(4, 0);
            ArrayList<String> jParagraphs = new ArrayList<String>();
            for (int n = 0; n < docCache.textSize(tPara); ++n) {
                tPara = new DocumentCache.TextParagraph(4, n);
                String para = docCache.getTextParagraph(tPara);
                List<String> sentences = lt.sentenceTokenize(para);
                ArrayList<String> jSentences = new ArrayList<String>();
                JSONObject jParagraph = new JSONObject();
                for (String sentence : sentences) {
                    JAnalyzedSentence jSentence = new JAnalyzedSentence(lt.getAnalyzedSentence(sentence));
                    jSentences.add(jSentence.getJSON());
                }
                jParagraph.put("pa", jSentences);
                jParagraphs.add(jParagraph.toString());
            }
            this.doc.put("locale", this.locale);
            this.doc.put("paragraphs", jParagraphs);
            this.writeIntoFile();
        }
        catch (IOException e) {
            MessageHandler.printException(e);
            return;
        }
    }

    String getLocaleAsString() {
        return this.locale;
    }

    void writeIntoFile() {
        try {
            File tmpCacheFile;
            File tmpDir = new File(OfficeTools.getLOConfigDir(), "tmp");
            if (tmpDir != null && !tmpDir.exists()) {
                tmpDir.mkdirs();
            }
            if ((tmpCacheFile = new File(tmpDir, "tmp_AnalyzedParagraphsCache")).exists()) {
                tmpCacheFile.delete();
            }
            GZIPOutputStream fileOut = new GZIPOutputStream(new FileOutputStream(tmpCacheFile.getAbsolutePath()));
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fileOut, StandardCharsets.UTF_8);
            out.write(this.doc.toString());
            out.close();
            fileOut.close();
            File cacheFile = new File(tmpDir, "AnalyzedParagraphsCache");
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
            tmpCacheFile.renameTo(cacheFile);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
    }

    private class JAnalyzedToken {
        private String posTag;
        private String lemma;
        private boolean hasNoTag = false;

        JAnalyzedToken(AnalyzedToken token) {
            this.posTag = token.getPOSTag() == null ? "" : token.getPOSTag();
            this.lemma = token.getLemma() == null ? "" : token.getLemma();
            this.hasNoTag = token.hasNoTag();
        }

        String getJSON() {
            JSONObject obj = new JSONObject();
            obj.put("pT", this.posTag);
            obj.put("le", this.lemma);
            obj.put("hT", this.hasNoTag);
            return obj.toString();
        }
    }

    private class JAnalyzedTokenReadings {
        private List<JAnalyzedToken> tokenReadings = new ArrayList<JAnalyzedToken>();
        private String token;
        private int startPos;

        JAnalyzedTokenReadings(AnalyzedTokenReadings anTokReadings) {
            this.token = anTokReadings.getToken();
            this.startPos = anTokReadings.getStartPos();
            for (AnalyzedToken aToken : anTokReadings.getReadings()) {
                this.tokenReadings.add(new JAnalyzedToken(aToken));
            }
        }

        String getJSON() {
            JSONObject obj = new JSONObject();
            obj.put("to", this.token);
            obj.put("sP", this.startPos);
            ArrayList<String> jReadings = new ArrayList<String>();
            for (JAnalyzedToken reading : this.tokenReadings) {
                jReadings.add(reading.getJSON());
            }
            obj.put("tR", jReadings);
            return obj.toString();
        }
    }

    private class JAnalyzedSentence {
        private List<JAnalyzedTokenReadings> tokens = new ArrayList<JAnalyzedTokenReadings>();

        JAnalyzedSentence(AnalyzedSentence sentences) {
            for (AnalyzedTokenReadings token : sentences.getTokensWithoutWhitespace()) {
                this.tokens.add(new JAnalyzedTokenReadings(token));
            }
        }

        String getJSON() {
            JSONObject obj = new JSONObject();
            ArrayList<String> jSentences = new ArrayList<String>();
            for (JAnalyzedTokenReadings token : this.tokens) {
                jSentences.add(token.getJSON());
            }
            obj.put("aS", jSentences);
            return obj.toString();
        }
    }
}

