/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.uno.XComponentContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.Languages;
import org.languagetool.gui.Tools;
import org.languagetool.language.Contributor;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;

public class AboutDialog {
    private final ResourceBundle messages;
    private final JDialog dialog = new JDialog();

    public AboutDialog(ResourceBundle messages) {
        this.messages = messages;
    }

    public void show(XComponentContext xContext) {
        try {
            String aboutText = Tools.getLabel(this.messages.getString("guiMenuAbout"));
            this.dialog.setName(aboutText);
            this.dialog.setTitle(aboutText);
            this.dialog.setDefaultCloseOperation(2);
            Image ltImage = OfficeTools.getLtImage();
            ((Frame)this.dialog.getOwner()).setIconImage(ltImage);
            ImageIcon icon = OfficeTools.getLtImageIcon(true);
            JLabel headerLabel = new JLabel(icon);
            JTextPane headerText = new JTextPane();
            headerText.setBackground(new Color(0, 0, 0, 0));
            headerText.setBorder(BorderFactory.createEmptyBorder());
            headerText.setContentType("text/html");
            headerText.setEditable(false);
            headerText.setOpaque(false);
            headerText.setText("<html><b>LanguageTool</b><br>" + this.messages.getString("loAboutLtDesc") + "</html>");
            JPanel headerPanel = new JPanel();
            headerPanel.add(headerLabel);
            headerPanel.add(headerText);
            JTextPane licensePane = new JTextPane();
            licensePane.setBackground(new Color(0, 0, 0, 0));
            licensePane.setBorder(BorderFactory.createEmptyBorder());
            licensePane.setContentType("text/html");
            licensePane.setEditable(false);
            licensePane.setOpaque(false);
            licensePane.setText("<html><p>Copyright (C) 2005-2024 the LanguageTool community and Daniel Naber.<br>This software is licensed under the GNU Lesser General Public License.<br><a href=\"https://www.languagetool.org\">https://www.languagetool.org</a><br></html>");
            Tools.addHyperlinkListener(licensePane);
            OfficeTools.OfficeProductInfo officeInfo = OfficeTools.getOfficeProductInfo(xContext);
            JTextPane techPane = new JTextPane();
            techPane.setBackground(new Color(0, 0, 0, 0));
            techPane.setBorder(BorderFactory.createEmptyBorder());
            techPane.setContentType("text/html");
            techPane.setEditable(false);
            techPane.setOpaque(false);
            techPane.setText(String.format("<html><p>LanguageTool %s (%s, %s)<br>OS: %s %s (%s)<br>%s %s%s (%s), %s<br>Java version: %s (%s)<br>Java max/total/free memory: %sMB, %sMB, %sMB</p></html>", JLanguageTool.VERSION, JLanguageTool.BUILD_DATE, JLanguageTool.GIT_SHORT_ID, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), officeInfo.ooName, officeInfo.ooVersion, officeInfo.ooExtension, officeInfo.ooVendor, officeInfo.ooLocale, System.getProperty("java.version"), System.getProperty("java.vm.vendor"), Runtime.getRuntime().maxMemory() / 1024L / 1024L, Runtime.getRuntime().totalMemory() / 1024L / 1024L, Runtime.getRuntime().freeMemory() / 1024L / 1024L));
            JTextPane aboutPane = new JTextPane();
            aboutPane.setBackground(new Color(0, 0, 0, 0));
            aboutPane.setBorder(BorderFactory.createEmptyBorder());
            aboutPane.setContentType("text/html");
            aboutPane.setEditable(false);
            aboutPane.setOpaque(false);
            aboutPane.setText(String.format("<html><p>Maintainer of the office extension: %s</p><p>Maintainers or former maintainers of the language modules -<br>(*) means language is unmaintained in LanguageTool:</p><br></html>", "Fred Kruse"));
            JTextPane maintainersPane = new JTextPane();
            maintainersPane.setBackground(new Color(0, 0, 0, 0));
            maintainersPane.setBorder(BorderFactory.createEmptyBorder());
            maintainersPane.setContentType("text/html");
            maintainersPane.setEditable(false);
            maintainersPane.setOpaque(false);
            maintainersPane.setText(this.getMaintainers());
            int prefWidth = Math.max(520, maintainersPane.getPreferredSize().width);
            int maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height / 2;
            maxHeight = Math.min(maintainersPane.getPreferredSize().height, maxHeight);
            maintainersPane.setPreferredSize(new Dimension(prefWidth, maxHeight));
            JScrollPane scrollPane = new JScrollPane(maintainersPane);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            JButton copyToClipboard = new JButton(this.messages.getString("loCopyToClipBoardDesc"));
            copyToClipboard.addActionListener(e -> {
                String str = String.format("\nLanguageTool %s (%s, %s)\nOS: %s %s (%s)\n%s %s%s (%s), %s\nJava version: %s (%s)\nJava max/total/free memory: %sMB, %sMB, %sMB\n", JLanguageTool.VERSION, JLanguageTool.BUILD_DATE, JLanguageTool.GIT_SHORT_ID, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), officeInfo.ooName, officeInfo.ooVersion, officeInfo.ooExtension, officeInfo.ooVendor, officeInfo.ooLocale, System.getProperty("java.version"), System.getProperty("java.vm.vendor"), Runtime.getRuntime().maxMemory() / 1024L / 1024L, Runtime.getRuntime().totalMemory() / 1024L / 1024L, Runtime.getRuntime().freeMemory() / 1024L / 1024L);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Clipboard clipboard = toolkit.getSystemClipboard();
                StringSelection strSel = new StringSelection(str);
                clipboard.setContents(strSel, null);
                this.close();
            });
            JButton OpenLogFilePath = new JButton(this.messages.getString("loOpenLogFolderDesc"));
            OpenLogFilePath.addActionListener(e -> {
                File logDir = OfficeTools.getLOConfigDir();
                this.close();
                try {
                    Desktop.getDesktop().open(logDir);
                }
                catch (IOException e1) {
                    MessageHandler.showError(e1);
                }
            });
            JButton close = new JButton(this.messages.getString("guiOOoCloseButton"));
            close.addActionListener(e -> this.close());
            JPanel versionButtonPanel = new JPanel();
            versionButtonPanel.setLayout(new GridBagLayout());
            GridBagConstraints cons = new GridBagConstraints();
            cons.insets = new Insets(6, 0, 0, 15);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.anchor = 17;
            cons.fill = 0;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            JLabel versionLabel = new JLabel(this.messages.getString("loVersionInformation") + ": ");
            Font f = versionLabel.getFont();
            versionLabel.setFont(f.deriveFont(f.getStyle() | 1));
            versionButtonPanel.add((Component)versionLabel, cons);
            ++cons.gridx;
            versionButtonPanel.add((Component)copyToClipboard, cons);
            cons.anchor = 13;
            ++cons.gridx;
            versionButtonPanel.add((Component)OpenLogFilePath, cons);
            JPanel closeButtonPanel = new JPanel();
            closeButtonPanel.setLayout(new GridBagLayout());
            cons = new GridBagConstraints();
            cons.insets = new Insets(6, 12, 0, 15);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.anchor = 13;
            cons.fill = 0;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            closeButtonPanel.add((Component)close, cons);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            panel.add(headerPanel);
            panel.add(licensePane);
            panel.add(versionButtonPanel);
            panel.add(techPane);
            panel.add(aboutPane);
            panel.add(scrollPane);
            panel.add(closeButtonPanel);
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new GridBagLayout());
            cons = new GridBagConstraints();
            cons.insets = new Insets(8, 8, 8, 8);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.weightx = 10.0;
            cons.weighty = 10.0;
            cons.fill = 1;
            cons.anchor = 18;
            contentPane.add((Component)panel, cons);
            this.dialog.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.dialog.getSize();
            this.dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
            this.dialog.setLocationByPlatform(true);
            this.dialog.setAutoRequestFocus(true);
            this.dialog.setVisible(true);
            this.dialog.setAlwaysOnTop(true);
            this.dialog.toFront();
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    private String getMaintainers() {
        TreeMap<String, Language> list = new TreeMap<String, Language>();
        for (Language lang : Languages.get()) {
            if (lang.isVariant() || lang.getMaintainers() == null) continue;
            list.put(this.messages.getString(lang.getShortCode()), lang);
        }
        StringBuilder str = new StringBuilder();
        str.append("<table border=0 cellspacing=0 cellpadding=0>");
        for (Map.Entry entry : list.entrySet()) {
            str.append("<tr valign=\"top\"><td>");
            str.append((String)entry.getKey());
            if (((Language)entry.getValue()).getMaintainedState() == LanguageMaintainedState.LookingForNewMaintainer) {
                str.append("(*)");
            }
            str.append(":</td>");
            str.append("<td>&nbsp;</td>");
            str.append("<td>");
            int i = 0;
            Contributor[] maintainers = ((Language)list.get(entry.getKey())).getMaintainers();
            if (maintainers != null) {
                for (Contributor contributor : maintainers) {
                    if (i > 0) {
                        str.append(", ");
                        if (i % 3 == 0) {
                            str.append("<br>");
                        }
                    }
                    str.append(contributor.getName());
                    ++i;
                }
            }
            str.append("</td></tr>");
        }
        str.append("</table>");
        return str.toString();
    }

    private String getMaintainersAsText() {
        TreeMap<String, Language> list = new TreeMap<String, Language>();
        for (Language lang : Languages.get()) {
            if (lang.isVariant() || lang.getMaintainers() == null) continue;
            list.put(this.messages.getString(lang.getShortCode()), lang);
        }
        StringBuilder str = new StringBuilder();
        for (Map.Entry entry : list.entrySet()) {
            str.append((String)entry.getKey());
            if (((Language)entry.getValue()).getMaintainedState() == LanguageMaintainedState.LookingForNewMaintainer) {
                str.append("(*)");
            }
            str.append(": ");
            int i = 0;
            Contributor[] maintainers = ((Language)list.get(entry.getKey())).getMaintainers();
            if (maintainers != null) {
                for (Contributor contributor : maintainers) {
                    if (i > 0) {
                        str.append(", ");
                    }
                    str.append(contributor.getName());
                    ++i;
                }
            }
            str.append("\n");
        }
        return str.toString();
    }

    public void close() {
        this.dialog.setVisible(false);
    }
}

