/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.remote.multiLang;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.languagetool.remote.RemoteIgnoreRange;
import org.languagetool.remote.RemoteLanguageTool;
import org.languagetool.remote.RemoteResult;
import org.languagetool.remote.multiLang.InjectedSentence;
import org.languagetool.remote.multiLang.MultiLangCorpora;
import org.languagetool.tools.Tools;

public final class MultiLanguageTextCheckEval {
    private static Random randomGen = new Random();
    private static int minMainLanguageSentences = 100;
    private static int maxOtherLanguageSentences = 15;
    private static int maxOtherLanguageSentencesAtOnce = 4;
    private static String mainLanguages = "de";
    private static String otherLanguage = "en";
    private static boolean useLangDetectionService = false;
    private static int rounds = 100;
    private static List<DetectionResults> roundResults = new ArrayList<DetectionResults>();
    private static boolean spamToMe = false;
    private static Set<String> allWrongRanges = new HashSet<String>();
    private static Set<String> allNotDetected = new HashSet<String>();
    private static boolean vsMode = false;

    public static void main(String[] args) {
        String inputFolder = "/home/stefan/Dokumente/Test_texte/multiLangChecker/creatorMode/";
        HashMap corporaFiles = new HashMap();
        try (Stream<Path> path = Files.walk(Paths.get(inputFolder, new String[0]), new FileVisitOption[0]);){
            path.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(pathToFile -> {
                try {
                    List<String> lines = Files.readAllLines(pathToFile);
                    String language = pathToFile.getFileName().toString().split("\\.")[0];
                    corporaFiles.put(language, lines);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException ex) {
            System.exit(1);
        }
        if (vsMode) {
            int i;
            ArrayList<MultiLangCorpora> savedCorpora = new ArrayList<MultiLangCorpora>();
            for (i = 0; i < rounds; ++i) {
                MultiLangCorpora corporaFromFiles = MultiLanguageTextCheckEval.createCorporaFromFiles(mainLanguages, (List)corporaFiles.get(mainLanguages), otherLanguage, (List)corporaFiles.get(otherLanguage));
                savedCorpora.add(corporaFromFiles);
                DetectionResults detectionResults = MultiLanguageTextCheckEval.runTest(corporaFromFiles, "http://localhost:8081");
                if (detectionResults != null) {
                    roundResults.add(detectionResults);
                    System.out.print(".");
                } else {
                    System.out.print("x");
                }
                if (rounds <= 1 || (i + 1) % (rounds / 10) != 0) continue;
                System.out.println(" " + (i + 1) + " finished");
            }
            MultiLanguageTextCheckEval.printSummary(" with LanguageDetection ");
            allNotDetected.clear();
            allWrongRanges.clear();
            roundResults.clear();
            for (i = 0; i < rounds; ++i) {
                DetectionResults detectionResults = MultiLanguageTextCheckEval.runTest((MultiLangCorpora)savedCorpora.get(i), "http://localhost:8082");
                if (detectionResults != null) {
                    roundResults.add(detectionResults);
                    System.out.print(".");
                } else {
                    System.out.print("x");
                }
                if (rounds <= 1 || (i + 1) % (rounds / 10) != 0) continue;
                System.out.println(" " + (i + 1) + " finished");
            }
            MultiLanguageTextCheckEval.printSummary(" without LanguageDetection");
        } else {
            for (int i = 0; i < rounds; ++i) {
                MultiLangCorpora corporaFromFiles = MultiLanguageTextCheckEval.createCorporaFromFiles(mainLanguages, (List)corporaFiles.get(mainLanguages), otherLanguage, (List)corporaFiles.get(otherLanguage));
                DetectionResults detectionResults = MultiLanguageTextCheckEval.runTest(corporaFromFiles);
                if (detectionResults != null) {
                    roundResults.add(detectionResults);
                    System.out.print(".");
                } else {
                    System.out.print("x");
                }
                if (rounds <= 1 || (i + 1) % (rounds / 10) != 0) continue;
                System.out.println(" " + (i + 1) + " finished");
            }
            MultiLanguageTextCheckEval.printSummary("normal");
        }
    }

    private static void printSummary(String mode) {
        System.out.println(rounds + " of " + mode + " finished");
        System.out.println("Avg. time to check: " + String.format("%.2f", roundResults.stream().mapToDouble(detectionResults -> ((DetectionResults)detectionResults).time).average().getAsDouble()) + " seconds");
        System.out.println("Avg. time to check (no MultiLanguage): " + String.format("%.2f", roundResults.stream().mapToDouble(detectionResults -> ((DetectionResults)detectionResults).timeWithout).average().getAsDouble()) + " seconds");
        System.out.println("Avg. timediff: " + String.format("%.2f", roundResults.stream().mapToDouble(DetectionResults::getTimeDiff).average().getAsDouble()) + " seconds");
        System.out.println("Avg. chars in corpora: " + String.format("%.2f", roundResults.stream().mapToDouble(detectionResults -> ((DetectionResults)detectionResults).charsInText).average().getAsDouble()));
        System.out.println("Avg. detection rate: " + String.format("%.2f", roundResults.stream().mapToDouble(detectionResults -> ((DetectionResults)detectionResults).detectionRate).average().getAsDouble()) + " %");
        System.out.println("Avg. sentences in corpora: " + String.format("%.2f", roundResults.stream().mapToDouble(detectionResults -> ((DetectionResults)detectionResults).sentencesInText).average().getAsDouble()));
        System.out.println("Avg. injected sentences in corpora: " + String.format("%.2f", roundResults.stream().mapToDouble(detectionResults -> ((DetectionResults)detectionResults).injectedSentecesInText).average().getAsDouble()));
        System.out.println("Avg. wrong detected: " + String.format("%.2f", roundResults.stream().mapToDouble(detectionResults -> ((DetectionResults)detectionResults).wrongDetected).average().getAsDouble()) + " sentences per corpora");
        if (rounds <= 10) {
            System.out.println("### Not detected sentences:");
            allNotDetected.forEach(System.out::println);
            System.out.println("### Wrong detected ranges:");
            allWrongRanges.forEach(System.out::println);
        }
    }

    private static MultiLangCorpora createCorporaFromFiles(String mainLanguage, List<String> mainLanguageLines, String otherLanguage, List<String> otherLanguageLines) {
        int sentencesInMainLanguageCorpus;
        if (spamToMe) {
            System.out.printf("Created mixed %s corpora with %s.%n", mainLanguage, otherLanguage);
        }
        if ((sentencesInMainLanguageCorpus = mainLanguageLines.size()) < minMainLanguageSentences) {
            System.err.printf("The corpora for %s has not enough lines.%n", mainLanguage);
            System.exit(1);
        }
        MultiLangCorpora mlc = new MultiLangCorpora(mainLanguage);
        int sentencesInNewCorpusCount = 0;
        int otherLanguageSentencesInjected = 0;
        String lastInjected = null;
        while (sentencesInNewCorpusCount < minMainLanguageSentences + maxOtherLanguageSentences) {
            int startLine;
            boolean addOther;
            int whichShouldITake = randomGen.nextInt(minMainLanguageSentences + maxOtherLanguageSentences);
            boolean bl = addOther = whichShouldITake < maxOtherLanguageSentences && otherLanguageSentencesInjected + maxOtherLanguageSentencesAtOnce <= maxOtherLanguageSentences;
            if (lastInjected == null || lastInjected.equals(otherLanguage) || !addOther) {
                startLine = randomGen.nextInt(sentencesInMainLanguageCorpus);
                mlc.addSentence(mainLanguageLines.get(startLine).trim());
                ++sentencesInNewCorpusCount;
                lastInjected = mainLanguages;
                continue;
            }
            startLine = randomGen.nextInt(otherLanguageLines.size() - maxOtherLanguageSentencesAtOnce);
            mlc.injectOtherSentence(otherLanguage, otherLanguageLines.get(startLine).trim());
            ++sentencesInNewCorpusCount;
            ++otherLanguageSentencesInjected;
            lastInjected = otherLanguage;
        }
        return mlc;
    }

    private static DetectionResults runTest(MultiLangCorpora mlc) {
        return MultiLanguageTextCheckEval.runTest(mlc, "http://localhost:8081");
    }

    private static DetectionResults runTest(MultiLangCorpora mlc, String languageToolServer) {
        RemoteLanguageTool remoteLanguageTool = new RemoteLanguageTool(Tools.getUrl((String)languageToolServer));
        String language = useLangDetectionService ? "auto" : MultiLanguageTextCheckEval.getSupportedLangCode(mlc.getLanguage());
        long startTime = System.currentTimeMillis();
        RemoteResult results = null;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("enableMultiLanguageChecks", "true");
            params.put("preferredLanguages", "de,en");
            results = remoteLanguageTool.check(mlc.getText(), language, params);
        }
        catch (RuntimeException ex) {
            if (spamToMe) {
                System.out.println("too many errors");
            }
            return null;
        }
        long endTime = System.currentTimeMillis();
        float timeToCheck = (float)(endTime - startTime) / 1000.0f;
        long startTimeRound2 = System.currentTimeMillis();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("enableMultiLanguageChecks", "false");
            params.put("preferredLanguages", "de");
            remoteLanguageTool.check(mlc.getText(), language, params);
        }
        catch (RuntimeException ex) {
            if (spamToMe) {
                System.out.println("too many errors");
            }
            return null;
        }
        long endTimeRound2 = System.currentTimeMillis();
        float timeToCheckRound2 = (float)(endTimeRound2 - startTimeRound2) / 1000.0f;
        ArrayList<String> detectedSentences = new ArrayList<String>();
        for (RemoteIgnoreRange range : results.getIgnoreRanges()) {
            detectedSentences.add(mlc.getText().substring(range.getFrom(), range.getTo()).trim());
        }
        List injectedLines = mlc.getInjectedSentences().stream().map(InjectedSentence::getText).collect(Collectors.toList());
        ArrayList detectedLines = new ArrayList(injectedLines);
        ArrayList notDetectedLines = new ArrayList(injectedLines);
        ArrayList wrongDetectedSentences = new ArrayList(detectedSentences);
        ArrayList<String> notWrongDetected = new ArrayList<String>();
        ArrayList<String> tmpRemoveFromWrongDetectedSentences = new ArrayList<String>();
        for (String sentence : wrongDetectedSentences) {
            for (String injectedLine : injectedLines) {
                if (!injectedLine.contains(sentence)) continue;
                notWrongDetected.add(injectedLine);
                tmpRemoveFromWrongDetectedSentences.add(sentence);
            }
        }
        wrongDetectedSentences.removeAll(tmpRemoveFromWrongDetectedSentences);
        notDetectedLines.removeAll(notWrongDetected);
        detectedLines.removeAll(notDetectedLines);
        allWrongRanges.addAll(wrongDetectedSentences);
        allNotDetected.addAll(notDetectedLines);
        if (rounds == 1) {
            System.out.println(mlc.getText());
        }
        return new DetectionResults(timeToCheck, timeToCheckRound2, (float)detectedLines.size() / (float)injectedLines.size() * 100.0f, wrongDetectedSentences.size(), mlc.getText().length(), mlc.getSentencesInText(), mlc.getInjectedSentences().size());
    }

    private static String getSupportedLangCode(String shortCode) {
        switch (shortCode) {
            case "de": {
                return "de-DE";
            }
            case "en": {
                return "en-US";
            }
            case "pt": {
                return "pt-BR";
            }
        }
        return shortCode;
    }

    static class DetectionResults {
        private float time;
        private float timeWithout;
        private float detectionRate;
        private int wrongDetected;
        private long charsInText;
        private int sentencesInText;
        private int injectedSentecesInText;

        DetectionResults(float time, float timeWithout, float detectionRate, int wrongDetected, long charsInText, int sentencesInText, int injectedSentecesInText) {
            this.time = time;
            this.timeWithout = timeWithout;
            this.detectionRate = detectionRate;
            this.wrongDetected = wrongDetected;
            this.charsInText = charsInText;
            this.sentencesInText = sentencesInText;
            this.injectedSentecesInText = injectedSentecesInText;
        }

        public float getTimeDiff() {
            return this.time - this.timeWithout;
        }
    }
}

