/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import org.languagetool.remote.CheckConfiguration;
import org.languagetool.remote.CheckConfigurationBuilder;
import org.languagetool.remote.RemoteLanguageTool;
import org.languagetool.remote.RemoteRuleMatch;
import org.languagetool.tools.DiffsAsMatches;
import org.languagetool.tools.PseudoMatch;
import org.languagetool.tools.Tools;

public class SentenceAnnotator {
    static HashMap<String, List<RemoteRuleMatch>> cachedMatches;
    private static final String timestamp;

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        if (args.length == 1) {
            String disabledRulesStr;
            String automaticAnnotationStr;
            String configurationFilename = args[0];
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(configurationFilename);
            prop.load(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
            AnnotatorConfig cfg = new AnnotatorConfig();
            cfg.remoteServer = prop.getProperty("remoteServer", "http://localhost:8081").trim();
            cfg.userName = prop.getProperty("userName", "").trim();
            cfg.annotatorName = prop.getProperty("annotatorName", "").trim();
            cfg.apiKey = prop.getProperty("apiKey", "").trim();
            cfg.inputFilePath = prop.getProperty("inputFile", "").trim();
            cfg.outputFilePath = prop.getProperty("outputFile", "").trim();
            cfg.languageCode = prop.getProperty("languageCode").trim();
            cfg.waitMilliseconds = Integer.valueOf(prop.getProperty("waitMilliseconds", "0").trim());
            String customParamsStr = prop.getProperty("customParams", "").trim();
            if (!customParamsStr.isEmpty()) {
                for (String customParam : customParamsStr.split(";")) {
                    String[] parts = customParam.split(",");
                    cfg.customParams.put(parts[0], parts[1]);
                }
            }
            cfg.automaticAnnotation = (automaticAnnotationStr = prop.getProperty("automaticAnnotation", "").trim()).equalsIgnoreCase("yes") || automaticAnnotationStr.equalsIgnoreCase("true");
            String ignoreStyleRulesStr = prop.getProperty("ignoreStyleRules", "yes").trim();
            cfg.ignoreStyleRules = ignoreStyleRulesStr.equalsIgnoreCase("yes") || ignoreStyleRulesStr.equalsIgnoreCase("true");
            String enabledOnlyRulesStr = prop.getProperty("enabledOnlyRules", "").trim();
            if (!enabledOnlyRulesStr.isEmpty()) {
                cfg.enabledOnlyRules = Arrays.asList(enabledOnlyRulesStr.split(","));
            }
            if (!(disabledRulesStr = prop.getProperty("disabledRules", "").trim()).isEmpty()) {
                cfg.disabledRules = Arrays.asList(disabledRulesStr.split(","));
            }
            cfg.ansiDefault = prop.getProperty("defaultColor", "").trim().replaceAll("\"", "");
            cfg.ansiHighlight = prop.getProperty("highlightColor", "").trim().replaceAll("\"", "");
            cfg.prepareConfiguration();
            if (cfg.automaticAnnotation) {
                SentenceAnnotator.runAutomaticAnnotation(cfg);
            } else {
                SentenceAnnotator.runAnnotation(cfg);
            }
        } else {
            SentenceAnnotator.writeHelp();
            System.exit(1);
        }
        System.out.println(SentenceAnnotator.printTimeFromStart(start, "Total time:"));
    }

    private static void runAnnotation(AnnotatorConfig cfg) throws IOException, NoSuchAlgorithmException, InterruptedException {
        List<String> lines = Files.readAllLines(Paths.get(cfg.inputFilePath, new String[0]));
        int numSentence = 0;
        Scanner sc = new Scanner(System.in);
        System.out.print("Start at line? ");
        String response = sc.nextLine();
        int startLine = 0;
        try {
            startLine = Integer.valueOf(response);
        }
        catch (NumberFormatException ex) {
            startLine = 0;
        }
        System.out.println("Starting at line " + String.valueOf(startLine) + " of file " + cfg.inputFilePath);
        boolean quit = false;
        block26: for (String line : lines) {
            String sentenceID;
            String originalSentence;
            if (quit) break;
            if (++numSentence < startLine) continue;
            String[] partsLine = line.split("\t");
            if (partsLine.length == 2) {
                originalSentence = partsLine[1];
                sentenceID = partsLine[0];
            } else {
                originalSentence = partsLine[0];
                sentenceID = "N/A";
            }
            String sentence = originalSentence;
            String sentenceHash = SentenceAnnotator.md5FromSentence(sentence);
            boolean done = false;
            ArrayList<String> fpMatches = new ArrayList<String>();
            int annotationsPerSentence = 0;
            while (!done) {
                String formattedSentence;
                List<RemoteRuleMatch> matches = SentenceAnnotator.getMatches(cfg, sentence);
                RemoteRuleMatch match = null;
                int i = 0;
                boolean isValidMatch = false;
                while (!isValidMatch && i < matches.size()) {
                    match = matches.get(i);
                    ++i;
                    boolean bl = isValidMatch = !fpMatches.contains(SentenceAnnotator.getMatchIdentifier(sentence, match));
                    if (cfg.ignoreStyleRules && match.getLocQualityIssueType().get().equals("style")) {
                        isValidMatch = false;
                    }
                    if (isValidMatch) continue;
                    match = null;
                }
                String formattedCorrectedSentence = formattedSentence = SentenceAnnotator.formatedSentence(sentence, match);
                String detectedErrorStr = "";
                System.out.println(cfg.ansiDefault + "=============================================");
                System.out.println("Sentence no. " + String.valueOf(numSentence));
                System.out.println("---------------------------------------------");
                System.out.println(cfg.ansiHighlight + formattedSentence + cfg.ansiDefault);
                System.out.println("---------------------------------------------");
                if (match != null) {
                    System.out.println(match.getMessage());
                    detectedErrorStr = sentence.substring(match.getErrorOffset(), match.getErrorOffset() + match.getErrorLength());
                }
                System.out.println(SentenceAnnotator.listSuggestions(match, detectedErrorStr));
                System.out.println("---------------------------------------------");
                System.out.print("Action? ");
                response = sc.nextLine();
                if (!response.contains(">>")) {
                    response = response.toLowerCase();
                }
                String errorType = "";
                int suggestionPos = -1;
                String suggestionApplied = "";
                int suggestionsTotal = 0;
                if (match != null) {
                    suggestionsTotal = match.getReplacements().get().size();
                }
                switch (response) {
                    case "r": {
                        sentence = originalSentence;
                        fpMatches.clear();
                        cfg.outStrB = new StringBuilder();
                        break;
                    }
                    case "q": {
                        done = true;
                        quit = true;
                        SentenceAnnotator.writeToOutputFile(cfg);
                        break;
                    }
                    case "d": {
                        done = true;
                        if (annotationsPerSentence == 0) {
                            errorType = "OK";
                        }
                        SentenceAnnotator.writeToOutputFile(cfg);
                        break;
                    }
                    case "g": {
                        done = true;
                        errorType = "IG";
                        cfg.outStrB = new StringBuilder();
                        match = null;
                        break;
                    }
                    case "i": {
                        fpMatches.add(SentenceAnnotator.getMatchIdentifier(sentence, match));
                        errorType = "IM";
                        break;
                    }
                    case "b": {
                        fpMatches.add(SentenceAnnotator.getMatchIdentifier(sentence, match));
                        errorType = "BO";
                        break;
                    }
                    case "f": {
                        fpMatches.add(SentenceAnnotator.getMatchIdentifier(sentence, match));
                        errorType = "FP";
                        break;
                    }
                    case "1": 
                    case "2": 
                    case "3": 
                    case "4": 
                    case "5": {
                        errorType = "TP";
                        if (suggestionsTotal > 1) {
                            errorType = "TPmultiple";
                        }
                        int r = Integer.valueOf(response);
                        if (match == null || r < 1 || r > 5) break;
                        formattedCorrectedSentence = SentenceAnnotator.formattedCorrectedSentence(sentence, match, r);
                        sentence = SentenceAnnotator.replaceSuggestion(sentence, match, r);
                        suggestionPos = r;
                        suggestionApplied = match.getReplacements().get().get(suggestionPos - 1);
                    }
                }
                if (quit) continue block26;
                if (response.startsWith(">>") && match != null) {
                    formattedCorrectedSentence = sentence.substring(0, match.getErrorOffset()) + "___" + response.substring(2) + "___" + sentence.substring(match.getErrorOffset() + match.getErrorLength());
                    sentence = sentence.substring(0, match.getErrorOffset()) + response.substring(2) + sentence.substring(match.getErrorOffset() + match.getErrorLength());
                    errorType = suggestionsTotal == 0 ? "TPno" : "TPwrong";
                    suggestionApplied = response.substring(2);
                } else if (response.contains(">>")) {
                    String[] parts = response.split(">>");
                    String toReplace = parts[0];
                    String replacement = parts[1];
                    int ind = sentence.indexOf(toReplace);
                    if (ind > -1) {
                        if (sentence.substring(ind + toReplace.length()).indexOf(toReplace) > -1) {
                            System.out.println("Cannot replace duplicate string in sentence.");
                        } else {
                            formattedSentence = sentence.substring(0, ind) + "___" + toReplace + "___" + sentence.substring(ind + toReplace.length());
                            formattedCorrectedSentence = sentence.substring(0, ind) + "___" + replacement + "___" + sentence.substring(ind + toReplace.length());
                            sentence = sentence.substring(0, ind) + replacement + sentence.substring(ind + toReplace.length());
                            System.out.println("FN: replacement done.");
                            errorType = "FN";
                            suggestionApplied = replacement;
                            detectedErrorStr = toReplace;
                        }
                    }
                }
                if (errorType.isEmpty()) continue;
                SentenceAnnotator.printOutputLine(cfg, sentenceHash, sentenceID, formattedSentence, formattedCorrectedSentence, errorType, detectedErrorStr, suggestionApplied, suggestionPos, suggestionsTotal, SentenceAnnotator.getFullId(match), SentenceAnnotator.getRuleCategoryId(match), SentenceAnnotator.getRuleType(match));
                ++annotationsPerSentence;
                if (!errorType.equals("OK") && !errorType.equals("IG")) continue;
                SentenceAnnotator.writeToOutputFile(cfg);
                cfg.outStrB = new StringBuilder();
            }
        }
        sc.close();
        cfg.out.close();
    }

    private static void runAutomaticAnnotation(AnnotatorConfig cfg) throws Exception {
        DiffsAsMatches diffsAsMatches = new DiffsAsMatches();
        List<String> lines = Files.readAllLines(Paths.get(cfg.inputFilePath, new String[0]));
        int numSentence = 0;
        System.out.println("Starting at line 1 of file " + cfg.inputFilePath);
        for (String line : lines) {
            ++numSentence;
            String[] parts = line.split("\t");
            if (parts.length < 2) {
                throw new Exception("Error: Lines from the input file should contain at least two tab-separated columns. Line: " + line);
            }
            String sentence = parts[0].replaceAll("__", "");
            String sentenceHash = SentenceAnnotator.md5FromSentence(sentence);
            String correctedSentence = parts[1].replaceAll("__", "");
            List matchesGolden = diffsAsMatches.getPseudoMatches(sentence, correctedSentence);
            if (parts.length < 3) {
                List<RemoteRuleMatch> matches = SentenceAnnotator.getMatches(cfg, sentence);
                correctedSentence = SentenceAnnotator.applyAllMatches(sentence, matches);
            } else {
                correctedSentence = parts[2].replaceAll("__", "");
            }
            RemoteRuleMatch match = null;
            List matchesEval = diffsAsMatches.getPseudoMatches(sentence, correctedSentence);
            String errorType = "";
            int iGolden = 0;
            int iEval = 0;
            while (iGolden < matchesGolden.size() || iEval < matchesEval.size()) {
                PseudoMatch iGMatch = null;
                PseudoMatch iEMatch = null;
                if (iGolden < matchesGolden.size()) {
                    iGMatch = (PseudoMatch)matchesGolden.get(iGolden);
                }
                if (iEval < matchesEval.size()) {
                    iEMatch = (PseudoMatch)matchesEval.get(iEval);
                }
                String formattedOriginalSentence = "";
                String formattedCorrectSentence = "";
                String detectedErrorStr = "";
                String replacement = "";
                if (iGMatch == null) {
                    errorType = "FP";
                    ++iEval;
                } else if (iEMatch == null) {
                    errorType = "FN";
                    ++iGolden;
                } else if (iGMatch.getFromPos() == iEMatch.getFromPos()) {
                    errorType = iEMatch.getReplacements().size() == 0 ? "TPns" : (((String)iGMatch.getReplacements().get(0)).equals(iEMatch.getReplacements().get(0)) ? "TP" : "TPws");
                    ++iGolden;
                    ++iEval;
                } else if (iGMatch.getFromPos() < iEMatch.getFromPos()) {
                    errorType = "FN";
                    ++iGolden;
                } else if (iGMatch.getFromPos() > iEMatch.getFromPos()) {
                    errorType = "FP";
                    ++iEval;
                }
                switch (errorType) {
                    case "FP": {
                        formattedCorrectSentence = formattedOriginalSentence = SentenceAnnotator.formatedSentence2(sentence, iEMatch);
                        detectedErrorStr = sentence.substring(iEMatch.getFromPos(), iEMatch.getToPos());
                        replacement = (String)iEMatch.getReplacements().get(0);
                        break;
                    }
                    case "FN": {
                        formattedOriginalSentence = SentenceAnnotator.formatedSentence2(sentence, iGMatch);
                        formattedCorrectSentence = SentenceAnnotator.formattedCorrectedSentence2(sentence, iGMatch);
                        detectedErrorStr = sentence.substring(iGMatch.getFromPos(), iGMatch.getToPos());
                        replacement = "";
                        break;
                    }
                    case "TP": 
                    case "TPns": 
                    case "TPws": {
                        formattedOriginalSentence = SentenceAnnotator.formatedSentence2(sentence, iGMatch);
                        formattedCorrectSentence = SentenceAnnotator.formattedCorrectedSentence2(sentence, iGMatch);
                        detectedErrorStr = sentence.substring(iGMatch.getFromPos(), iGMatch.getToPos());
                        replacement = (String)iEMatch.getReplacements().get(0);
                    }
                }
                SentenceAnnotator.printOutputLine(cfg, sentenceHash, "N/A", formattedOriginalSentence, formattedCorrectSentence, errorType, detectedErrorStr, replacement, -1, 1, SentenceAnnotator.getFullId(match), SentenceAnnotator.getRuleCategoryId(match), SentenceAnnotator.getRuleType(match));
            }
            SentenceAnnotator.writeToOutputFile(cfg);
        }
        cfg.out.close();
    }

    private static StringBuilder prepareFieldForCSV(String fieldValue) {
        if (fieldValue.contains("\"") || fieldValue.contains(",")) {
            return new StringBuilder().append("\"").append(fieldValue.replaceAll("\"", "\"\"")).append("\"");
        }
        return new StringBuilder(fieldValue);
    }

    private static StringBuilder createCSVRow(String[] fieldValues) {
        StringBuilder row = new StringBuilder();
        for (int i = 0; i < fieldValues.length; ++i) {
            row.append((CharSequence)SentenceAnnotator.prepareFieldForCSV(fieldValues[i]));
            if (i == fieldValues.length - 1) continue;
            row.append(",");
        }
        return row;
    }

    private static String md5FromSentence(String sentence) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(sentence.getBytes());
        byte[] digest = md5.digest();
        return DatatypeConverter.printHexBinary((byte[])digest);
    }

    private static void printOutputLine(AnnotatorConfig cfg, String sentenceHash, String sentenceID, String errorSentence, String correctedSentence, String errorType, String detectedErrorStr, String suggestion, int suggestionPos, int suggestionsTotal, String ruleId, String ruleCategory, String ruleType) {
        String[] rowFields = new String[]{sentenceHash, sentenceID, cfg.annotatorName, timestamp, errorSentence, correctedSentence, errorType, detectedErrorStr, suggestion, ruleId, String.valueOf(suggestionPos), String.valueOf(suggestionsTotal), ruleCategory, ruleType};
        cfg.outStrB.append((CharSequence)SentenceAnnotator.createCSVRow(rowFields)).append("\n");
    }

    private static void writeToOutputFile(AnnotatorConfig cfg) throws IOException {
        cfg.out.write(cfg.outStrB.toString());
        cfg.out.flush();
        cfg.outStrB = new StringBuilder();
    }

    private static String getMatchIdentifier(String sentence, RemoteRuleMatch match) {
        StringBuilder sb = new StringBuilder();
        sb.append(sentence.substring(match.getErrorOffset(), match.getErrorOffset() + match.getErrorLength()));
        sb.append(SentenceAnnotator.getFullId(match));
        sb.append(match.getReplacements().get().toString());
        return sb.toString();
    }

    private static String getFullId(RemoteRuleMatch match) {
        String ruleId = "";
        if (match != null) {
            String subId = null;
            try {
                subId = match.getRuleSubId().get();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            ruleId = subId != null ? match.getRuleId() + "[" + subId + "]" : match.getRuleId();
        }
        return ruleId;
    }

    private static String getRuleCategoryId(RemoteRuleMatch match) {
        String categoryId = "";
        if (match != null) {
            try {
                categoryId = match.getCategoryId().get();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return categoryId;
    }

    private static String getRuleType(RemoteRuleMatch match) {
        String ruleType = "";
        if (match != null) {
            try {
                ruleType = match.getLocQualityIssueType().get().toString();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return ruleType;
    }

    private static String listSuggestions(RemoteRuleMatch match, String detectedErrorStr) {
        StringBuilder sb = new StringBuilder();
        sb.append("(Q)uit (D)one (G)arbled (R)estartSentence ");
        if (match == null) {
            sb.append("NO MATCHES");
            return sb.toString();
        }
        sb.append("(I)gnoreMatch ");
        sb.append("(B)othOK ");
        sb.append("(F)P ");
        if (!detectedErrorStr.isEmpty()) {
            sb.append("\nUNDERLINED_STR: ");
            sb.append(detectedErrorStr);
        }
        if (match.getReplacements().get().size() > 0) {
            sb.append("\nSUGGESTIONS: ");
        }
        int i = 1;
        for (String suggestion : match.getReplacements().get()) {
            sb.append(String.valueOf(i) + ") " + suggestion + " ");
            if (++i <= 5) continue;
            break;
        }
        return sb.toString();
    }

    private static String formatedSentence2(String line, PseudoMatch match) {
        if (match == null) {
            return line;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(line.substring(0, match.getFromPos()));
        sb.append("___");
        sb.append(line.substring(match.getFromPos(), match.getToPos()));
        sb.append("___");
        sb.append(line.substring(match.getToPos()));
        return sb.toString();
    }

    private static String formattedCorrectedSentence2(String line, PseudoMatch match) {
        if (match == null) {
            return line;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(line.substring(0, match.getFromPos()));
        sb.append("___");
        sb.append((String)match.getReplacements().get(0));
        sb.append("___");
        sb.append(line.substring(match.getToPos()));
        return sb.toString();
    }

    private static String formatedSentence(String line, RemoteRuleMatch match) {
        if (match == null) {
            return line;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(line.substring(0, match.getErrorOffset()));
        sb.append("___");
        sb.append(line.substring(match.getErrorOffset(), match.getErrorOffset() + match.getErrorLength()));
        sb.append("___");
        sb.append(line.substring(match.getErrorOffset() + match.getErrorLength()));
        return sb.toString();
    }

    private static String applyAllMatches(String line, List<RemoteRuleMatch> matches) {
        if (matches == null) {
            return line;
        }
        int correctedPos = 0;
        String sentence = line;
        for (RemoteRuleMatch match : matches) {
            List<String> replacements = match.getReplacements().get();
            if (replacements.size() <= 0) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(sentence.substring(0, match.getErrorOffset() + correctedPos));
            sb.append(match.getReplacements().get().get(0));
            sb.append(sentence.substring(match.getErrorOffset() + match.getErrorLength() + correctedPos));
            sentence = sb.toString();
            correctedPos += match.getReplacements().get().get(0).length() - match.getErrorLength();
        }
        return sentence;
    }

    private static String formattedCorrectedSentence(String line, RemoteRuleMatch match, int i) {
        if (match == null) {
            return line;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(line.substring(0, match.getErrorOffset()));
        sb.append("___");
        sb.append(match.getReplacements().get().get(i - 1));
        sb.append("___");
        sb.append(line.substring(match.getErrorOffset() + match.getErrorLength()));
        return sb.toString();
    }

    private static String replaceSuggestion(String line, RemoteRuleMatch match, int i) {
        StringBuilder sb = new StringBuilder();
        sb.append(line.substring(0, match.getErrorOffset()));
        sb.append(match.getReplacements().get().get(i - 1));
        sb.append(line.substring(match.getErrorOffset() + match.getErrorLength()));
        return sb.toString();
    }

    private static List<RemoteRuleMatch> getMatches(AnnotatorConfig cfg, String sentence) throws InterruptedException {
        List<RemoteRuleMatch> matches;
        TimeUnit.MILLISECONDS.sleep(cfg.waitMilliseconds.intValue());
        if (cachedMatches.containsKey(sentence)) {
            matches = cachedMatches.get(sentence);
        } else {
            try {
                matches = cfg.lt.check(sentence, cfg.ltConfig, cfg.customParams).getMatches();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                SentenceAnnotator.wait(1000);
                matches = cfg.lt.check(sentence, cfg.ltConfig, cfg.customParams).getMatches();
            }
            cachedMatches.put(sentence, matches);
        }
        return matches;
    }

    private static String printTimeFromStart(long start, String tag) {
        if (tag.isEmpty()) {
            tag = "Time:";
        }
        long totalSecs = (long)((double)(System.currentTimeMillis() - start) / 1000.0);
        long hours = totalSecs / 3600L;
        int minutes = (int)(totalSecs % 3600L / 60L);
        int seconds = (int)(totalSecs % 60L);
        return String.format(tag + " %02d:%02d:%02d\n", hours, minutes, seconds);
    }

    private static void writeHelp() {
        System.out.println("Usage: " + SentenceAnnotator.class.getSimpleName() + " <configuration file>");
    }

    public static void wait(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        timestamp = String.format("%1$tY-%1$tm-%1$td", new Date());
    }

    private static class AnnotatorConfig {
        String remoteServer;
        String userName;
        String annotatorName;
        String apiKey;
        String inputFilePath;
        String outputFilePath;
        String languageCode;
        File inputFile;
        File outputFile;
        boolean automaticAnnotation;
        boolean ignoreStyleRules;
        CheckConfiguration ltConfig;
        RemoteLanguageTool lt;
        Map<String, String> customParams = new HashMap<String, String>();
        FileWriter out;
        StringBuilder outStrB;
        String ansiDefault = "";
        String ansiHighlight = "";
        List<String> enabledOnlyRules = new ArrayList<String>();
        List<String> disabledRules = new ArrayList<String>();
        Integer waitMilliseconds = 0;

        private AnnotatorConfig() {
        }

        void prepareConfiguration() throws IOException {
            CheckConfigurationBuilder cfgBuilder = new CheckConfigurationBuilder(this.languageCode);
            if (this.enabledOnlyRules.isEmpty()) {
                cfgBuilder.disabledRuleIds("WHITESPACE_RULE");
                if (!this.disabledRules.isEmpty()) {
                    cfgBuilder.disabledRuleIds(this.disabledRules);
                }
            } else {
                cfgBuilder.enabledRuleIds(this.enabledOnlyRules).enabledOnly();
            }
            if (!this.userName.isEmpty() && !this.apiKey.isEmpty()) {
                cfgBuilder.username(this.userName).apiKey(this.apiKey).build();
            }
            this.ltConfig = cfgBuilder.build();
            this.inputFile = new File(this.inputFilePath);
            if (!this.inputFile.exists() || this.inputFile.isDirectory()) {
                throw new IOException("File not found: " + this.inputFile);
            }
            String fileName = this.inputFile.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            this.outputFile = this.outputFilePath.isEmpty() ? new File(this.inputFile.getParentFile() + "/" + fileName + "-annotations.csv") : new File(this.outputFilePath);
            this.outStrB = new StringBuilder();
            this.out = new FileWriter(this.outputFile, true);
            cachedMatches = new HashMap();
            this.lt = new RemoteLanguageTool(Tools.getUrl((String)this.remoteServer));
        }
    }
}

