/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.languagetool.remote.CheckConfiguration;
import org.languagetool.remote.CheckConfigurationBuilder;
import org.languagetool.remote.RemoteConfigurationInfo;
import org.languagetool.remote.RemoteIgnoreRange;
import org.languagetool.remote.RemoteResult;
import org.languagetool.remote.RemoteRuleMatch;
import org.languagetool.remote.RemoteServer;

public class RemoteLanguageTool {
    private static final String V2_CHECK = "/v2/check";
    private static final String V2_MAXTEXTLENGTH = "/v2/maxtextlength";
    private static final String V2_CONFIGINFO = "/v2/configinfo";
    private final ObjectMapper mapper = new ObjectMapper();
    private final URL serverBaseUrl;

    public RemoteLanguageTool(URL serverBaseUrl) {
        if (serverBaseUrl.toString().endsWith("/")) {
            throw new IllegalArgumentException("Server base URL must not end with '/': " + serverBaseUrl);
        }
        this.serverBaseUrl = Objects.requireNonNull(serverBaseUrl);
    }

    public RemoteResult check(String text, String langCode) {
        return this.check(this.getUrlParams(text, new CheckConfigurationBuilder(langCode).build(), null));
    }

    public RemoteResult check(String text, String langCode, Map<String, String> customParams) {
        return this.check(this.getUrlParams(text, new CheckConfigurationBuilder(langCode).build(), customParams));
    }

    public RemoteResult check(String text, CheckConfiguration config) {
        return this.check(this.getUrlParams(text, config, null));
    }

    public RemoteResult check(String text, CheckConfiguration config, Map<String, String> customParams) {
        return this.check(this.getUrlParams(text, config, customParams));
    }

    private String getUrlParams(String text, CheckConfiguration config, Map<String, String> customParams) {
        StringBuilder params = new StringBuilder();
        this.append(params, "text", text);
        if (config.getMotherTongueLangCode() != null) {
            this.append(params, "motherTongue", config.getMotherTongueLangCode());
        }
        if (config.guessLanguage()) {
            this.append(params, "language", "auto");
        } else {
            this.append(params, "language", config.getLangCode().orElse("auto"));
        }
        if (config.getEnabledRuleIds().size() > 0) {
            this.append(params, "enabledRules", String.join((CharSequence)",", config.getEnabledRuleIds()));
        }
        if (config.enabledOnly()) {
            this.append(params, "enabledOnly", "yes");
        }
        if (config.getDisabledRuleIds().size() > 0) {
            this.append(params, "disabledRules", String.join((CharSequence)",", config.getDisabledRuleIds()));
        }
        if (config.getMode() != null) {
            this.append(params, "mode", config.getMode());
        }
        if (config.getLevel() != null) {
            this.append(params, "level", config.getLevel());
        }
        if (config.getRuleValues().size() > 0) {
            this.append(params, "ruleValues", String.join((CharSequence)",", config.getRuleValues()));
        }
        if (config.getTextSessionID() != null) {
            this.append(params, "textSessionId", config.getTextSessionID());
        }
        if (config.getUsername() != null) {
            this.append(params, "username", config.getUsername());
        }
        if (config.getAPIKey() != null) {
            this.append(params, "apiKey", config.getAPIKey());
        }
        if (customParams != null) {
            customParams.forEach((key, value) -> this.append(params, (String)key, (String)value));
        }
        this.append(params, "useragent", "java-http-client");
        return params.toString();
    }

    private void append(StringBuilder params, String paramName, String paramValue) {
        if (params.length() > 0) {
            params.append('&');
        }
        params.append(paramName).append('=').append(this.encode(paramValue));
    }

    private String encode(String text) {
        try {
            return URLEncoder.encode(text, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private RemoteResult check(String urlParameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public RemoteConfigurationInfo getConfigurationInfo(String urlParameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public int getMaxTextLength() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    HttpURLConnection getConnection(byte[] postData, URL url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setInstanceFollowRedirects(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("charset", "utf-8");
            conn.setRequestProperty("Content-Length", Integer.toString(postData.length));
            try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
                wr.write(postData);
            }
            return conn;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String readStream(InputStream stream, String encoding) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(stream, encoding);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        return sb.toString();
    }

    private RemoteResult parseJson(InputStream inputStream) throws XMLStreamException, IOException {
        Map map = (Map)this.mapper.readValue(inputStream, Map.class);
        Map languageObj = (Map)map.get("language");
        String language = (String)languageObj.get("name");
        String languageCode = (String)languageObj.get("code");
        Map detectedLanguageObj = (Map)languageObj.get("detectedLanguage");
        String languageDetectedCode = null;
        String languageDetectedName = null;
        if (detectedLanguageObj != null) {
            languageDetectedCode = (String)detectedLanguageObj.get("code");
            languageDetectedName = (String)detectedLanguageObj.get("name");
        }
        Map software = (Map)map.get("software");
        RemoteServer remoteServer = new RemoteServer((String)software.get("name"), (String)software.get("version"), (String)software.get("buildDate"));
        ArrayList matches = (ArrayList)map.get("matches");
        ArrayList<RemoteRuleMatch> result = new ArrayList<RemoteRuleMatch>();
        for (Object match : matches) {
            RemoteRuleMatch remoteMatch = this.getMatch((Map)match);
            result.add(remoteMatch);
        }
        ArrayList ignoreRanges = (ArrayList)map.get("ignoreRanges");
        ArrayList<RemoteIgnoreRange> remoteIgnoreRanges = new ArrayList<RemoteIgnoreRange>();
        if (ignoreRanges != null) {
            for (Object range : ignoreRanges) {
                RemoteIgnoreRange remoteIgnoreRange = this.getIgnoreRange((Map)range);
                remoteIgnoreRanges.add(remoteIgnoreRange);
            }
        }
        return new RemoteResult(language, languageCode, languageDetectedCode, languageDetectedName, result, remoteIgnoreRanges, remoteServer);
    }

    private RemoteIgnoreRange getIgnoreRange(Map<String, Object> range) {
        int from = (Integer)range.get("from");
        int to = (Integer)range.get("to");
        String langCode = (String)((Map)range.get("language")).get("code");
        return new RemoteIgnoreRange(from, to, langCode);
    }

    private RemoteRuleMatch getMatch(Map<String, Object> match) {
        Map rule = (Map)match.get("rule");
        int offset = (Integer)this.getRequired(match, "offset");
        int errorLength = (Integer)this.getRequired(match, "length");
        Map context = (Map)match.get("context");
        int contextOffset = (Integer)this.getRequired(context, "offset");
        RemoteRuleMatch remoteMatch = new RemoteRuleMatch(this.getRequiredString(rule, "id"), this.getRequiredString(rule, "description"), this.getRequiredString(match, "message"), this.getRequiredString(context, "text"), contextOffset, offset, errorLength);
        remoteMatch.setShortMsg(this.getOrNull(match, "shortMessage"));
        remoteMatch.setRuleSubId(this.getOrNull(rule, "subId"));
        remoteMatch.setLocQualityIssueType(this.getOrNull(rule, "issueType"));
        List<String> urls = this.getValueList(rule, "urls");
        if (urls.size() > 0) {
            remoteMatch.setUrl(urls.get(0));
        }
        Map category = (Map)rule.get("category");
        remoteMatch.setCategory(this.getOrNull(category, "name"));
        remoteMatch.setCategoryId(this.getOrNull(category, "id"));
        remoteMatch.setReplacements(this.getValueList(match, "replacements"));
        return remoteMatch;
    }

    private Object getRequired(Map<String, Object> elem, String propertyName) {
        Object val = elem.get(propertyName);
        if (val != null) {
            return val;
        }
        throw new RuntimeException("JSON item " + elem + " doesn't contain required property '" + propertyName + "'");
    }

    private String getRequiredString(Map<String, Object> elem, String propertyName) {
        return (String)this.getRequired(elem, propertyName);
    }

    private String getOrNull(Map<String, Object> elem, String propertyName) {
        Object val = elem.get(propertyName);
        if (val != null) {
            return (String)val;
        }
        return null;
    }

    private List<String> getValueList(Map<String, Object> match, String propertyName) {
        List matches = (List)match.get(propertyName);
        ArrayList<String> l = new ArrayList<String>();
        if (matches != null) {
            for (Object o : matches) {
                Map item = (Map)o;
                l.add((String)item.get("value"));
            }
        }
        return l;
    }
}

