/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Scanner;
import org.languagetool.remote.CheckConfiguration;
import org.languagetool.remote.CheckConfigurationBuilder;
import org.languagetool.remote.RemoteLanguageTool;
import org.languagetool.remote.RemoteRuleMatch;
import org.languagetool.tools.Tools;

public class CorrectionLoopFinderApi {
    private static final int linesToSkip = 0;

    private static void run(Configuration cfg) throws IOException {
        Scanner sc = new Scanner(cfg.inputFile);
        int lineCount = 0;
        while (sc.hasNextLine()) {
            String line = sc.nextLine();
            if (++lineCount < 0) {
                if (lineCount % 1000 != 0) continue;
                System.out.println(lineCount + " skipped ...");
                continue;
            }
            List<RemoteRuleMatch> matches = null;
            try {
                matches = cfg.lt.check(line, cfg.ltConfig, cfg.customParams).getMatches();
            }
            catch (RuntimeException e) {
                System.err.println("An exception occurred: " + e.getMessage());
            }
            if (matches != null) {
                block5: for (RemoteRuleMatch match : matches) {
                    int suggCount = 0;
                    for (String repl : match.getReplacements().get()) {
                        if (++suggCount > 5) continue block5;
                        String corr = new StringBuilder(line).replace(match.getErrorOffset(), match.getErrorOffset() + match.getErrorLength(), repl).toString();
                        List<RemoteRuleMatch> corrMatches = null;
                        try {
                            corrMatches = cfg.lt.check(corr, cfg.ltConfig, cfg.customParams).getMatches();
                        }
                        catch (RuntimeException e) {
                            System.err.println("An exception occurred: " + e.getMessage());
                        }
                        if (corrMatches == null) continue;
                        for (RemoteRuleMatch corrMatch : corrMatches) {
                            for (String repl2 : corrMatch.getReplacements().get()) {
                                String corr2 = new StringBuilder(corr).replace(corrMatch.getErrorOffset(), corrMatch.getErrorOffset() + corrMatch.getErrorLength(), repl2).toString();
                                if (!corr2.equals(line)) continue;
                                cfg.out.write("LOOP by " + CorrectionLoopFinderApi.getFullId(match) + "/" + CorrectionLoopFinderApi.getFullId(corrMatch) + ": " + line.substring(match.getErrorOffset(), match.getErrorOffset() + match.getErrorLength()) + " => " + repl + "\n");
                                cfg.out.write("  " + line + "\n");
                                cfg.out.write("  " + corr + "\n");
                            }
                        }
                    }
                }
                cfg.out.flush();
            }
            if (lineCount % 1000 != 0) continue;
            System.out.println(lineCount + "...");
        }
    }

    public static void main(String[] args) throws IOException {
        String disabledRulesStr;
        String enabledOnlyRulesStr;
        if (args.length != 1) {
            System.out.println("Usage: " + CorrectionLoopFinderApi.class.getSimpleName() + " <configFile>");
            System.exit(1);
        }
        String configurationFilename = args[0];
        Properties prop = new Properties();
        FileInputStream fis = new FileInputStream(configurationFilename);
        prop.load(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
        Configuration cfg = new Configuration();
        cfg.remoteServer = prop.getProperty("remoteServer", "http://localhost:8081").trim();
        cfg.userName = prop.getProperty("userName", "").trim();
        cfg.annotatorName = prop.getProperty("annotatorName", "").trim();
        cfg.apiKey = prop.getProperty("apiKey", "").trim();
        cfg.inputFilePath = prop.getProperty("inputFile", "").trim();
        cfg.outputFilePath = prop.getProperty("outputFile", "").trim();
        cfg.languageCode = prop.getProperty("languageCode").trim();
        String customParamsStr = prop.getProperty("customParams", "").trim();
        if (!customParamsStr.isEmpty()) {
            for (String customParam : customParamsStr.split(";")) {
                String[] parts = customParam.split(",");
                cfg.customParams.put(parts[0], parts[1]);
            }
        }
        if (!(enabledOnlyRulesStr = prop.getProperty("enabledOnlyRules", "").trim()).isEmpty()) {
            cfg.enabledOnlyRules = Arrays.asList(enabledOnlyRulesStr.split(","));
        }
        if (!(disabledRulesStr = prop.getProperty("disabledRules", "").trim()).isEmpty()) {
            cfg.disabledRules = Arrays.asList(disabledRulesStr.split(","));
        }
        cfg.ansiDefault = prop.getProperty("defaultColor", "").trim().replaceAll("\"", "");
        cfg.ansiHighlight = prop.getProperty("highlightColor", "").trim().replaceAll("\"", "");
        cfg.prepareConfiguration();
        CorrectionLoopFinderApi.run(cfg);
    }

    private static String getFullId(RemoteRuleMatch match) {
        String ruleId = "";
        if (match != null) {
            String subId = null;
            try {
                subId = match.getRuleSubId().get();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            ruleId = subId != null ? match.getRuleId() + "[" + subId + "]" : match.getRuleId();
        }
        return ruleId;
    }

    private static class Configuration {
        String remoteServer;
        String userName;
        String annotatorName;
        String apiKey;
        String inputFilePath;
        String outputFilePath;
        String languageCode;
        File inputFile;
        File outputFile;
        boolean automaticAnnotation;
        CheckConfiguration ltConfig;
        RemoteLanguageTool lt;
        Map<String, String> customParams = new HashMap<String, String>();
        FileWriter out;
        StringBuilder outStrB;
        String ansiDefault = "";
        String ansiHighlight = "";
        List<String> enabledOnlyRules = new ArrayList<String>();
        List<String> disabledRules = new ArrayList<String>();

        private Configuration() {
        }

        void prepareConfiguration() throws IOException {
            CheckConfigurationBuilder cfgBuilder = new CheckConfigurationBuilder(this.languageCode);
            if (this.enabledOnlyRules.isEmpty()) {
                cfgBuilder.disabledRuleIds("WHITESPACE_RULE");
                cfgBuilder.disabledRuleIds("UNPAIRED_BRACKETS");
                if (!this.disabledRules.isEmpty()) {
                    cfgBuilder.disabledRuleIds(this.disabledRules);
                }
            } else {
                cfgBuilder.enabledRuleIds(this.enabledOnlyRules).enabledOnly();
            }
            if (!this.userName.isEmpty() && !this.apiKey.isEmpty()) {
                cfgBuilder.username(this.userName).apiKey(this.apiKey).build();
            }
            this.ltConfig = cfgBuilder.build();
            this.inputFile = new File(this.inputFilePath);
            if (!this.inputFile.exists() || this.inputFile.isDirectory()) {
                throw new IOException("File not found: " + this.inputFile);
            }
            String fileName = this.inputFile.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            this.outputFile = this.outputFilePath.isEmpty() ? new File(this.inputFile.getParentFile() + "/" + fileName + "-loops.txt") : new File(this.outputFilePath);
            this.outStrB = new StringBuilder();
            this.out = new FileWriter(this.outputFile, true);
            this.lt = new RemoteLanguageTool(Tools.getUrl((String)this.remoteServer));
        }
    }
}

