/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.remote;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.remote.CheckConfiguration;
import org.languagetool.remote.CheckConfigurationBuilder;
import org.languagetool.remote.RemoteLanguageTool;
import org.languagetool.remote.RemoteRuleMatch;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public class ArtificialErrorEval {
    static String[] words = new String[2];
    static String[] lemmas = new String[2];
    static String[] fakeRuleIDs = new String[2];
    static List<String> classifyTypes = Arrays.asList("TP", "FP", "TN", "FN", "TPns", "TPws");
    static int[][] results = new int[2][6];
    static int[] accumulateResults = new int[6];
    static RemoteLanguageTool lt;
    static JLanguageTool localLt;
    static Synthesizer synth;
    static int maxInputSentences;
    static boolean verboseOutput;
    static boolean unidirectional;
    static boolean wholeword;
    static boolean isDoubleLetters;
    static boolean isDiacritics;
    static boolean inflected;
    static boolean isParallelCorpus;
    static int columnCorrect;
    static int columnIncorrect;
    static Pattern pWordboundaries;
    static int countLine;
    static int checkedSentences;
    static int maxCheckedSentences;
    static List<String> onlyRules;
    static List<String> disabledRules;
    static List<String> enabledOnlyRules;
    static String summaryOutputFilename;
    static String verboseOutputFilename;
    static String errorCategory;
    static String langCode;
    static Language language;
    static String corpusFilePath;
    static String outputPathRoot;
    static HashMap<String, List<RemoteRuleMatch>> cachedMatches;
    static String remoteServer;
    static String userName;
    static String apiKey;

    public static void main(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        if (args.length == 1) {
            String onlyRulesStr;
            String disabledRulesStr;
            String configurationFilename = args[0];
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(configurationFilename);
            prop.load(new InputStreamReader((InputStream)fis, Charset.forName("UTF-8")));
            String maxInputSentencesStr = prop.getProperty("maxInputSentences");
            String maxCheckedSentencesStr = prop.getProperty("maxCheckedSentences");
            if (maxInputSentencesStr != null) {
                maxInputSentences = Integer.parseInt(maxInputSentencesStr);
            }
            if (maxCheckedSentencesStr != null) {
                maxCheckedSentences = Integer.parseInt(maxCheckedSentencesStr) + 1;
            }
            boolean printSummaryDetails = Boolean.parseBoolean(prop.getProperty("printSummaryDetails", "true"));
            boolean printHeader = Boolean.parseBoolean(prop.getProperty("printHeader", "true"));
            remoteServer = prop.getProperty("remoteServer", "http://localhost:8081");
            String enabledOnlyRulesStr = prop.getProperty("enabledOnlyRules", "").trim();
            if (!enabledOnlyRulesStr.isEmpty()) {
                enabledOnlyRules = Arrays.asList(enabledOnlyRulesStr.split(","));
            }
            if (!(disabledRulesStr = prop.getProperty("disabledRules", "")).isEmpty()) {
                disabledRules = Arrays.asList(disabledRulesStr.split(","));
            }
            if (!(onlyRulesStr = prop.getProperty("onlyRules", "")).isEmpty()) {
                onlyRules = Arrays.asList(onlyRulesStr.split(","));
            }
            userName = prop.getProperty("userName", "");
            apiKey = prop.getProperty("apiKey", "");
            String inputFolder = prop.getProperty("inputFolder", "").trim();
            String outputFolder = prop.getProperty("outputFolder", inputFolder).trim();
            String inputFilename = prop.getProperty("inputFile", "").trim();
            if (!inputFilename.isEmpty()) {
                ArtificialErrorEval.runEvaluationOnFile(prop.getProperty("languageCode"), inputFilename, outputFolder);
            }
            if (!inputFolder.isEmpty()) {
                File[] inputFiles;
                summaryOutputFilename = outputFolder + "/" + prop.getProperty("languageCode") + "-summary.tsv";
                ArtificialErrorEval.appendToFile(summaryOutputFilename, "Category\tRules\tSentences\tPrecision\tRecall\tTP\tFP\tTN\tFN\tTPns\tTPws");
                for (File inputFile : inputFiles = new File(inputFolder).listFiles(File::isFile)) {
                    ArtificialErrorEval.runEvaluationOnFile(prop.getProperty("languageCode"), inputFile.getAbsolutePath(), outputFolder);
                }
            }
        } else if (args.length == 2) {
            ArtificialErrorEval.runEvaluationOnFile(args[0], args[1], "");
        } else {
            ArtificialErrorEval.writeHelp();
            System.exit(1);
        }
        System.out.println(ArtificialErrorEval.printTimeFromStart(start, "Total time:"));
    }

    private static void runEvaluationOnFile(String languageCode, String inputFile, String outputFolder) throws IOException {
        langCode = languageCode;
        corpusFilePath = inputFile;
        verboseOutput = true;
        language = Languages.getLanguageForShortCode((String)langCode);
        localLt = new JLanguageTool(language);
        synth = language.getSynthesizer();
        lt = new RemoteLanguageTool(Tools.getUrl((String)remoteServer));
        File corpusFile = new File(corpusFilePath);
        if (!corpusFile.exists() || corpusFile.isDirectory()) {
            throw new IOException("File not found: " + corpusFilePath);
        }
        String fileName = corpusFile.getName();
        System.out.println("Analyzing file: " + fileName);
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        verboseOutputFilename = outputFolder.isEmpty() ? corpusFile.getParentFile() + "/" + fileName + "-results.txt" : outputFolder + fileName + "-results.txt";
        unidirectional = false;
        wholeword = true;
        isDoubleLetters = false;
        isDiacritics = false;
        inflected = false;
        isParallelCorpus = false;
        columnCorrect = 1;
        columnIncorrect = 2;
        if (fileName.startsWith("parallelcorpus") || fileName.startsWith("pc-")) {
            isParallelCorpus = true;
            unidirectional = true;
            wholeword = false;
            String[] parts = fileName.split("-");
            if (parts.length > 2) {
                columnCorrect = Integer.parseInt(parts[1]);
                columnIncorrect = Integer.parseInt(parts[2]);
            }
        } else if (fileName.equals("diacritics")) {
            isDiacritics = true;
            unidirectional = true;
        } else if (fileName.equals("double_letters")) {
            isDoubleLetters = true;
            unidirectional = true;
        } else {
            String[] parts = fileName.split("~");
            ArtificialErrorEval.words[0] = parts[0].replaceAll("_", " ");
            ArtificialErrorEval.words[1] = parts[1].replaceAll("_", " ");
            if (parts.length > 2) {
                unidirectional = parts[2].equals("u");
                if (parts[2].equals("u_notwholeword")) {
                    unidirectional = true;
                    wholeword = false;
                }
                if (parts[2].equals("notwholeword")) {
                    wholeword = false;
                }
            }
        }
        ArtificialErrorEval.run(true);
    }

    private static void runEvaluationOnFolders(String inputFolder, String outputFolder, boolean printSummaryDetails, boolean printHeader) throws IOException {
        File[] languageDirectories;
        verboseOutput = true;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date(System.currentTimeMillis());
        outputPathRoot = outputFolder + "/" + formatter.format(date);
        Files.createDirectories(Paths.get(outputPathRoot, new String[0]), new FileAttribute[0]);
        lt = new RemoteLanguageTool(Tools.getUrl((String)remoteServer));
        for (File languageDirectory : languageDirectories = new File(inputFolder).listFiles(File::isDirectory)) {
            File[] categoryDirectories;
            langCode = languageDirectory.getName();
            language = Languages.getLanguageForShortCode((String)langCode);
            Files.createDirectories(Paths.get(outputPathRoot + "/" + langCode, new String[0]), new FileAttribute[0]);
            summaryOutputFilename = outputPathRoot + "/" + langCode + "/" + langCode + ".tsv";
            if (printHeader) {
                ArtificialErrorEval.appendToFile(summaryOutputFilename, "Category\tRules\tSentences\tPrecision\tRecall\tTP\tFP\tTN\tFN\tTPns\tTPws");
            }
            for (File categoryDirectory : categoryDirectories = languageDirectory.listFiles(File::isDirectory)) {
                File[] corpusFiles;
                Arrays.fill(accumulateResults, 0);
                errorCategory = categoryDirectory.getName();
                Files.createDirectories(Paths.get(outputPathRoot + "/" + langCode + "/" + errorCategory, new String[0]), new FileAttribute[0]);
                for (File myCorpusFile : corpusFiles = categoryDirectory.listFiles(File::isFile)) {
                    String[] parts;
                    corpusFilePath = myCorpusFile.getAbsolutePath();
                    String fileName = myCorpusFile.getName();
                    System.out.println("Analyzing file: " + fileName);
                    fileName = fileName.substring(0, fileName.lastIndexOf(46));
                    unidirectional = false;
                    wholeword = true;
                    isDoubleLetters = false;
                    isDiacritics = false;
                    inflected = false;
                    isParallelCorpus = false;
                    columnCorrect = 1;
                    columnIncorrect = 2;
                    if (fileName.startsWith("parallelcorpus") || fileName.startsWith("pc-")) {
                        isParallelCorpus = true;
                        unidirectional = true;
                        parts = fileName.split("-");
                        if (parts.length > 2) {
                            columnCorrect = Integer.parseInt(parts[1]);
                            columnIncorrect = Integer.parseInt(parts[2]);
                        }
                    } else if (fileName.equals("diacritics")) {
                        isDiacritics = true;
                        unidirectional = true;
                    } else if (fileName.equals("double_letters")) {
                        isDoubleLetters = true;
                        unidirectional = true;
                    } else {
                        parts = fileName.split("~");
                        ArtificialErrorEval.words[0] = parts[0].replaceAll("_", " ");
                        ArtificialErrorEval.words[1] = parts[1].replaceAll("_", " ");
                        if (parts.length > 2) {
                            unidirectional = parts[2].equals("u");
                            if (parts[2].equals("u_notwholeword")) {
                                unidirectional = true;
                                wholeword = false;
                            }
                            if (parts[2].equals("notwholeword")) {
                                wholeword = false;
                            }
                        }
                    }
                    verboseOutputFilename = outputPathRoot + "/" + langCode + "/" + errorCategory + "/" + myCorpusFile.getName();
                    ArtificialErrorEval.run(printSummaryDetails);
                }
                float precision = (float)accumulateResults[1] / (float)(accumulateResults[1] + accumulateResults[2]);
                float recall = (float)accumulateResults[1] / (float)(accumulateResults[1] + accumulateResults[4]);
                ArtificialErrorEval.appendToFile(summaryOutputFilename, errorCategory + "\tTOTAL\t" + accumulateResults[0] + "\t" + String.format(Locale.ROOT, "%.4f", Float.valueOf(precision)) + "\t" + String.format(Locale.ROOT, "%.4f", Float.valueOf(recall)) + "\t" + accumulateResults[1] + "\t" + accumulateResults[2] + "\t" + accumulateResults[3] + "\t" + accumulateResults[4] + "\t");
            }
        }
        System.out.println("FINISHED!");
    }

    private static void run(boolean printSummaryDetails) throws IOException {
        int ignoredLines = 0;
        Arrays.fill(results[0], 0);
        Arrays.fill(results[1], 0);
        ArtificialErrorEval.fakeRuleIDs[0] = "rules_" + words[0] + "->" + words[1];
        ArtificialErrorEval.fakeRuleIDs[1] = "rules_" + words[1] + "->" + words[0];
        CheckConfigurationBuilder cfgBuilder = new CheckConfigurationBuilder(langCode);
        if (enabledOnlyRules.isEmpty()) {
            cfgBuilder.disabledRuleIds("WHITESPACE_RULE");
            if (!disabledRules.isEmpty()) {
                cfgBuilder.disabledRuleIds(disabledRules);
            }
        } else {
            cfgBuilder.enabledRuleIds(enabledOnlyRules).enabledOnly();
        }
        if (!userName.isEmpty() && !apiKey.isEmpty()) {
            cfgBuilder.username(userName).apiKey(apiKey).build();
        }
        CheckConfiguration config = cfgBuilder.build();
        long start = System.currentTimeMillis();
        List<String> lines = Files.readAllLines(Paths.get(corpusFilePath, new String[0]));
        if (!(inflected || isDoubleLetters || isDiacritics || isParallelCorpus)) {
            Object mWordBoundaries = pWordboundaries.matcher(words[0]);
            Pattern p0 = ((Matcher)mWordBoundaries).matches() && wholeword ? Pattern.compile("\\b" + words[0] + "\\b", 66) : Pattern.compile(words[0], 66);
            mWordBoundaries = pWordboundaries.matcher(words[1]);
            Pattern p1 = ((Matcher)mWordBoundaries).matches() && wholeword ? Pattern.compile("\\b" + words[1] + "\\b", 66) : Pattern.compile(words[1], 66);
            countLine = 0;
            checkedSentences = 0;
            for (String line : lines) {
                Matcher m;
                cachedMatches = new HashMap();
                if (++countLine > maxInputSentences || checkedSentences > maxCheckedSentences) break;
                boolean foundSomething = false;
                if (words[0].length() > 0) {
                    m = p0.matcher(line);
                    while (m.find()) {
                        foundSomething = true;
                        ArtificialErrorEval.analyzeSentence(line, 0, m.start(), config);
                    }
                }
                if (words[1].length() > 0) {
                    m = p1.matcher(line);
                    while (m.find()) {
                        foundSomething = true;
                        ArtificialErrorEval.analyzeSentence(line, 1, m.start(), config);
                    }
                }
                if (foundSomething) continue;
            }
        }
        if (isParallelCorpus) {
            Pattern p = Pattern.compile("(.*)__(.*)__(.*)");
            countLine = 0;
            checkedSentences = 0;
            for (String line : lines) {
                String incorrectSentence;
                cachedMatches = new HashMap();
                if (++countLine > maxInputSentences || checkedSentences > maxCheckedSentences) break;
                String[] parts = line.split("\t");
                if (parts.length < columnCorrect && parts.length < columnIncorrect) continue;
                String correctSource = parts[columnCorrect - 1];
                String incorrectSource = parts[columnIncorrect - 1];
                ArtificialErrorEval.words[0] = null;
                ArtificialErrorEval.words[1] = null;
                String correctSentence = correctSource.replaceAll("__", "");
                if (correctSentence.equals(incorrectSentence = incorrectSource.replaceAll("__", ""))) {
                    ArtificialErrorEval.printSentenceOutput("IGNORED LINE: sentences are identical!", correctSource, 0, "");
                    ++ignoredLines;
                    continue;
                }
                List diffs = StringTools.getDifference((String)correctSentence, (String)incorrectSentence);
                int posError = ((String)diffs.get(0)).length();
                ArtificialErrorEval.words[1] = (String)diffs.get(1);
                ArtificialErrorEval.words[0] = (String)diffs.get(2);
                if (words[1] == null) continue;
                ArtificialErrorEval.analyzeSentence(correctSentence, 1, posError, config);
                ArtificialErrorEval.words[0] = words[1];
                ArtificialErrorEval.words[1] = null;
                ArtificialErrorEval.analyzeSentence(correctSentence, 0, posError, config);
            }
        }
        if (isDoubleLetters) {
            ArtificialErrorEval.fakeRuleIDs[0] = "rules_double_letters";
            countLine = 0;
            checkedSentences = 0;
            Iterator<String> p1 = Pattern.compile("([a-zA-Z])\\1+");
            for (String line : lines) {
                cachedMatches = new HashMap();
                if (++countLine > maxInputSentences || checkedSentences > maxCheckedSentences) break;
                Matcher m = ((Pattern)((Object)p1)).matcher(line);
                while (m.find()) {
                    ArtificialErrorEval.words[1] = m.group(0);
                    ArtificialErrorEval.words[0] = words[1].substring(0, 1);
                    ArtificialErrorEval.analyzeSentence(line, 1, m.start(), config);
                }
            }
        }
        if (isDiacritics) {
            countLine = 0;
            checkedSentences = 0;
            for (String line : lines) {
                cachedMatches = new HashMap();
                if (++countLine > maxInputSentences || checkedSentences > maxCheckedSentences) break;
                List tokens = language.getWordTokenizer().tokenize(line);
                int pos = 0;
                for (String token : tokens) {
                    if (StringTools.hasDiacritics((String)token)) {
                        ArtificialErrorEval.words[1] = token;
                        ArtificialErrorEval.words[0] = StringTools.removeDiacritics((String)token);
                        ArtificialErrorEval.analyzeSentence(line, 1, pos, config);
                    }
                    pos += token.length();
                }
            }
        }
        if (inflected) {
            countLine = 0;
            checkedSentences = 0;
            for (String line : lines) {
                cachedMatches = new HashMap();
                if (++countLine > maxInputSentences || checkedSentences > maxCheckedSentences) break;
                List analyzedSentences = localLt.analyzeText(line);
                boolean foundSomething = false;
                for (AnalyzedSentence analyzedSentence : analyzedSentences) {
                    for (AnalyzedTokenReadings token : analyzedSentence.getTokensWithoutWhitespace()) {
                        String[] syntheziedWords;
                        AnalyzedToken atr2;
                        AnalyzedToken atr1;
                        if (lemmas[0].length() > 0 && token.hasLemma(lemmas[0])) {
                            ArtificialErrorEval.words[0] = token.getToken();
                            atr1 = token.readingWithLemma(lemmas[0]);
                            atr2 = new AnalyzedToken(atr1.getToken(), atr1.getPOSTag(), lemmas[1]);
                            syntheziedWords = synth.synthesize(atr2, atr2.getPOSTag());
                            ArtificialErrorEval.words[1] = syntheziedWords[0];
                            foundSomething = true;
                            ArtificialErrorEval.analyzeSentence(line, 0, token.getStartPos(), config);
                        }
                        if (lemmas[1].length() <= 0 || !token.hasLemma(lemmas[1])) continue;
                        ArtificialErrorEval.words[1] = token.getToken();
                        atr1 = token.readingWithLemma(lemmas[1]);
                        atr2 = new AnalyzedToken(atr1.getToken(), atr1.getPOSTag(), lemmas[0]);
                        syntheziedWords = synth.synthesize(atr2, atr2.getPOSTag());
                        ArtificialErrorEval.words[0] = syntheziedWords[0];
                        foundSomething = true;
                        ArtificialErrorEval.analyzeSentence(line, 1, token.getStartPos(), config);
                    }
                }
            }
        }
        int oneOrTwo = unidirectional ? 1 : 2;
        for (int i = 0; i < oneOrTwo; ++i) {
            float precision = (float)results[i][classifyTypes.indexOf("TP")] / (float)(results[i][classifyTypes.indexOf("TP")] + results[i][classifyTypes.indexOf("FP")]);
            float recall = (float)results[i][classifyTypes.indexOf("TP")] / (float)(results[i][classifyTypes.indexOf("TP")] + results[i][classifyTypes.indexOf("FN")] + results[i][classifyTypes.indexOf("TPns")] + results[i][classifyTypes.indexOf("TPws")]);
            float recall2 = (float)(results[i][classifyTypes.indexOf("TP")] + results[i][classifyTypes.indexOf("TPns")]) / (float)(results[i][classifyTypes.indexOf("TP")] + results[i][classifyTypes.indexOf("FN")] + results[i][classifyTypes.indexOf("TPns")] + results[i][classifyTypes.indexOf("TPws")]);
            int errorsTotal = results[i][classifyTypes.indexOf("TP")] + results[i][classifyTypes.indexOf("FP")] + results[i][classifyTypes.indexOf("TN")] + results[i][classifyTypes.indexOf("FN")] + results[i][classifyTypes.indexOf("TPns")] + results[i][classifyTypes.indexOf("TPws")];
            StringWriter resultsString = new StringWriter();
            resultsString.append("-------------------------------------\n");
            resultsString.append("Results for " + fakeRuleIDs[i] + "\n");
            int nCorrectSentences = results[i][1] + results[i][2];
            int nIncorrectSentences = results[i][0] + results[i][4] + results[i][5] + results[i][3];
            resultsString.append("Total sentences: " + String.valueOf(errorsTotal) + "\n");
            resultsString.append(ArtificialErrorEval.formattedAbsoluteAndPercentage("\nCorrect sentences", nCorrectSentences, nCorrectSentences + nIncorrectSentences));
            resultsString.append(ArtificialErrorEval.formattedAbsoluteAndPercentage("FP", results[i][1], nCorrectSentences));
            resultsString.append(ArtificialErrorEval.formattedAbsoluteAndPercentage("TN", results[i][2], nCorrectSentences));
            resultsString.append(ArtificialErrorEval.formattedAbsoluteAndPercentage("\nIncorrect sentences", nIncorrectSentences, nCorrectSentences + nIncorrectSentences));
            resultsString.append(ArtificialErrorEval.formattedAbsoluteAndPercentage("TP (total)", results[i][4] + results[i][5] + results[i][0], nIncorrectSentences));
            resultsString.append(ArtificialErrorEval.formattedAbsoluteAndPercentage(" TP (expected suggestion)", results[i][0], nIncorrectSentences));
            resultsString.append(ArtificialErrorEval.formattedAbsoluteAndPercentage(" TPns (no suggestion)", results[i][4], nIncorrectSentences));
            resultsString.append(ArtificialErrorEval.formattedAbsoluteAndPercentage(" TPws (wrong suggestion)", results[i][5], nIncorrectSentences));
            resultsString.append(ArtificialErrorEval.formattedAbsoluteAndPercentage("FN", results[i][3], nIncorrectSentences));
            resultsString.append("\nPrecision: " + String.format(Locale.ROOT, "%.4f", Float.valueOf(precision)) + "\n");
            resultsString.append("Recall: " + String.format(Locale.ROOT, "%.4f", Float.valueOf(recall)) + "\n");
            resultsString.append("Recall (including empty suggestions): " + String.format(Locale.ROOT, "%.4f", Float.valueOf(recall2)) + "\n");
            if (ignoredLines > 0) {
                resultsString.append("\nIgnored lines from source: " + ignoredLines + "\n");
            }
            resultsString.append(ArtificialErrorEval.printTimeFromStart(start, ""));
            resultsString.append("\n" + ArtificialErrorEval.printCurrentDateTime() + "\n");
            ArtificialErrorEval.appendToFile(verboseOutputFilename, resultsString.toString());
            if (printSummaryDetails) {
                ArtificialErrorEval.appendToFile(summaryOutputFilename, errorCategory + "\t" + fakeRuleIDs[i] + "\t" + errorsTotal + "\t" + String.format(Locale.ROOT, "%.4f", Float.valueOf(precision)) + "\t" + String.format(Locale.ROOT, "%.4f", Float.valueOf(recall)) + "\t" + results[i][classifyTypes.indexOf("TP")] + "\t" + results[i][classifyTypes.indexOf("FP")] + "\t" + results[i][classifyTypes.indexOf("TN")] + "\t" + results[i][classifyTypes.indexOf("FN")] + "\t" + results[i][classifyTypes.indexOf("TPns")] + "\t" + results[i][classifyTypes.indexOf("TPws")] + "\t");
            }
            accumulateResults[0] = accumulateResults[0] + errorsTotal;
            accumulateResults[1] = accumulateResults[1] + results[i][classifyTypes.indexOf("TP")];
            accumulateResults[2] = accumulateResults[2] + results[i][classifyTypes.indexOf("FP")];
            accumulateResults[3] = accumulateResults[3] + results[i][classifyTypes.indexOf("TN")];
            accumulateResults[4] = accumulateResults[4] + results[i][classifyTypes.indexOf("FN")];
        }
        System.out.println(ArtificialErrorEval.printTimeFromStart(start, ""));
        System.out.println("-------------------------------------");
    }

    private static String formattedAbsoluteAndPercentage(String tag, int i, int j) {
        float percentage = (float)i * 100.0f / (float)j;
        StringWriter r = new StringWriter();
        r.append(tag + ": ");
        r.append(Integer.toString(i));
        r.append(" (");
        r.append(String.format(Locale.ROOT, "%.2f", Float.valueOf(percentage)));
        r.append("%)\n");
        return r.toString();
    }

    private static String printTimeFromStart(long start, String tag) {
        if (tag.isEmpty()) {
            tag = "Time:";
        }
        long totalSecs = (long)((double)(System.currentTimeMillis() - start) / 1000.0);
        long hours = totalSecs / 3600L;
        int minutes = (int)(totalSecs % 3600L / 60L);
        int seconds = (int)(totalSecs % 60L);
        return String.format(tag + " %02d:%02d:%02d\n", hours, minutes, seconds);
    }

    private static void appendToFile(String FilePath, String text) throws IOException {
        if (!FilePath.isEmpty()) {
            try (BufferedWriter out = new BufferedWriter(new FileWriter(FilePath, true));){
                out.write(text + "\n");
            }
        } else {
            System.out.println(text);
        }
    }

    private static void analyzeSentence(String correctSentence, int j, int fromPos, CheckConfiguration config) throws IOException {
        if (!unidirectional || j == 0) {
            List<String> ruleIDs;
            List<RemoteRuleMatch> matchesCorrect;
            if (cachedMatches.containsKey(correctSentence)) {
                matchesCorrect = cachedMatches.get(correctSentence);
            } else {
                try {
                    matchesCorrect = lt.check(correctSentence, config).getMatches();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    ArtificialErrorEval.wait(1000);
                    matchesCorrect = lt.check(correctSentence, config).getMatches();
                }
                ++checkedSentences;
                cachedMatches.put(correctSentence, matchesCorrect);
            }
            String replaceWith = words[1 - j];
            String originalString = correctSentence.substring(fromPos, fromPos + words[j].length());
            if (wholeword && StringTools.isCapitalizedWord((String)originalString) && replaceWith != null) {
                replaceWith = StringTools.uppercaseFirstChar((String)replaceWith);
            }
            if ((ruleIDs = ArtificialErrorEval.ruleIDsAtPos(matchesCorrect, fromPos, replaceWith)).size() > 0) {
                int[] nArray = results[j];
                int n = classifyTypes.indexOf("FP");
                nArray[n] = nArray[n] + 1;
                ArtificialErrorEval.printSentenceOutput("FP", correctSentence, j, String.join((CharSequence)",", ruleIDs));
            } else {
                int[] nArray = results[j];
                int n = classifyTypes.indexOf("TN");
                nArray[n] = nArray[n] + 1;
            }
        }
        if (!(unidirectional && j != 1 || words[1 - j] == null)) {
            List<RemoteRuleMatch> matchesWrong;
            String wrongSentence;
            String replaceWith = words[1 - j];
            String originalString = correctSentence.substring(fromPos, fromPos + words[j].length());
            if (wholeword) {
                replaceWith = StringTools.preserveCase((String)replaceWith, (String)originalString);
            }
            if ((wrongSentence = correctSentence.substring(0, fromPos) + replaceWith + correctSentence.substring(fromPos + words[j].length(), correctSentence.length())).equals(correctSentence)) {
                ArtificialErrorEval.printSentenceOutput("Error: word cannot be replaced", correctSentence, j, "");
                return;
            }
            if (cachedMatches.containsKey(wrongSentence)) {
                matchesWrong = cachedMatches.get(wrongSentence);
            } else {
                try {
                    matchesWrong = lt.check(wrongSentence, config).getMatches();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    ArtificialErrorEval.wait(1000);
                    matchesWrong = lt.check(wrongSentence, config).getMatches();
                }
                ++checkedSentences;
                cachedMatches.put(wrongSentence, matchesWrong);
            }
            List<String> ruleIDs = ArtificialErrorEval.ruleIDsAtPos(matchesWrong, fromPos, originalString);
            if (ruleIDs.size() > 0) {
                if (ArtificialErrorEval.isExpectedSuggestionAtPos(matchesWrong, fromPos, originalString, wrongSentence, correctSentence)) {
                    int[] nArray = results[1 - j];
                    int n = classifyTypes.indexOf("TP");
                    nArray[n] = nArray[n] + 1;
                    ArtificialErrorEval.printSentenceOutput("TP", wrongSentence, 1 - j, String.join((CharSequence)",", ruleIDs));
                } else if (ArtificialErrorEval.isEmptySuggestionAtPos(matchesWrong, fromPos, originalString, wrongSentence, correctSentence)) {
                    int[] nArray = results[1 - j];
                    int n = classifyTypes.indexOf("TPns");
                    nArray[n] = nArray[n] + 1;
                    ArtificialErrorEval.printSentenceOutput("TPns", wrongSentence, 1 - j, String.join((CharSequence)",", ruleIDs));
                } else {
                    int[] nArray = results[1 - j];
                    int n = classifyTypes.indexOf("TPws");
                    nArray[n] = nArray[n] + 1;
                    ArtificialErrorEval.printSentenceOutput("TPws", wrongSentence, 1 - j, String.join((CharSequence)",", ruleIDs));
                }
            } else {
                int[] nArray = results[1 - j];
                int n = classifyTypes.indexOf("FN");
                nArray[n] = nArray[n] + 1;
                ArtificialErrorEval.printSentenceOutput("FN", wrongSentence, 1 - j, "");
            }
        }
    }

    private static void printSentenceOutput(String classification, String sentence, int i, String ruleIds) throws IOException {
        if (verboseOutput) {
            String fakeRuleID = "";
            fakeRuleID = fakeRuleIDs[i].contains("null") ? "rules_" + words[i] + "->" + words[1 - i] : fakeRuleIDs[i];
            if (verboseOutputFilename.isEmpty()) {
                System.out.println(countLine + ". " + classification + ": " + sentence + " \u2013\u2013 " + fakeRuleID + ":" + ruleIds);
            } else {
                try (BufferedWriter out = new BufferedWriter(new FileWriter(verboseOutputFilename, true));){
                    out.write(countLine + "\t" + classification + "\t" + sentence + "\t" + fakeRuleID + ":" + ruleIds + "\n");
                }
            }
        }
    }

    private static List<String> ruleIDsAtPos(List<RemoteRuleMatch> matchesCorrect, int pos, String expectedSuggestion) {
        ArrayList<String> ruleIDs = new ArrayList<String>();
        for (RemoteRuleMatch match : matchesCorrect) {
            if (match.getErrorOffset() > pos || match.getErrorOffset() + match.getErrorLength() < pos || disabledRules.contains(match.getRuleId()) || !onlyRules.isEmpty() && !onlyRules.contains(match.getRuleId())) continue;
            String subId = null;
            try {
                subId = match.getRuleSubId().get();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            if (subId != null) {
                ruleIDs.add(match.getRuleId() + "[" + match.getRuleSubId().get() + "]");
                continue;
            }
            ruleIDs.add(match.getRuleId());
        }
        return ruleIDs;
    }

    private static boolean isExpectedSuggestionAtPos(List<RemoteRuleMatch> matchesCorrect, int pos, String expectedSuggestion, String wrongSentence, String correctSentence) {
        for (RemoteRuleMatch match : matchesCorrect) {
            if (match.getErrorOffset() > pos || match.getErrorOffset() + match.getErrorLength() < pos) continue;
            for (String s : match.getReplacements().get()) {
                String correctedSentence = wrongSentence.substring(0, match.getErrorOffset()) + s + wrongSentence.substring(match.getErrorOffset() + match.getErrorLength(), wrongSentence.length());
                if (!correctedSentence.equals(correctSentence)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isEmptySuggestionAtPos(List<RemoteRuleMatch> matchesCorrect, int pos, String expectedSuggestion, String wrongSentence, String correctSentence) {
        for (RemoteRuleMatch match : matchesCorrect) {
            if (match.getReplacements().get().size() != 0 || match.getErrorOffset() > pos || match.getErrorOffset() + match.getErrorLength() < pos) continue;
            return true;
        }
        return false;
    }

    private static void writeHelp() {
        System.out.println("Usage 1: " + ArtificialErrorEval.class.getSimpleName() + " <language code> <input file>");
        System.out.println("Usage 2: " + ArtificialErrorEval.class.getSimpleName() + " <configuration file>");
    }

    public static void wait(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private static String printCurrentDateTime() {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        return dtf.format(now);
    }

    static {
        maxInputSentences = 1000000;
        verboseOutput = false;
        unidirectional = false;
        wholeword = true;
        isDoubleLetters = false;
        isDiacritics = false;
        inflected = false;
        isParallelCorpus = false;
        columnCorrect = 1;
        columnIncorrect = 2;
        pWordboundaries = Pattern.compile("\\b.+\\b");
        countLine = 0;
        checkedSentences = 0;
        maxCheckedSentences = 1000000;
        onlyRules = new ArrayList<String>();
        disabledRules = new ArrayList<String>();
        enabledOnlyRules = new ArrayList<String>();
        summaryOutputFilename = "";
        verboseOutputFilename = "";
        errorCategory = "";
        langCode = "";
        corpusFilePath = "";
        outputPathRoot = "";
        remoteServer = "http://localhost:8081";
        userName = "";
        apiKey = "";
    }
}

