/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.sql.Statement;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="query", args={Statement.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="update", args={Statement.class}), @Signature(type=StatementHandler.class, method="batch", args={Statement.class})})
public class LoggingInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(LoggingInterceptor.class);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object intercept(Invocation invocation) throws Throwable {
        Object object;
        Object target = invocation.getTarget();
        long startTime = System.currentTimeMillis();
        StatementHandler statementHandler = (StatementHandler)target;
        try {
            object = invocation.proceed();
        }
        catch (Throwable throwable) {
            long endTime = System.currentTimeMillis();
            long time = endTime - startTime;
            BoundSql boundSql = statementHandler.getBoundSql();
            String sql = WHITESPACE_PATTERN.matcher(boundSql.getSql()).replaceAll(" ");
            Object parameterObject = boundSql.getParameterObject();
            logger.info("Executing SQL: [{}, {}] takes {}ms", sql, parameterObject, time);
            throw throwable;
        }
        long endTime = System.currentTimeMillis();
        long time = endTime - startTime;
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = WHITESPACE_PATTERN.matcher(boundSql.getSql()).replaceAll(" ");
        Object parameterObject = boundSql.getParameterObject();
        logger.info("Executing SQL: [{}, {}] takes {}ms", sql, parameterObject, time);
        return object;
    }
}

