# one-liner to load a bigger deploy script. work around a limitation for a longer line
# also useful to load deploy script to non-interactive shell

stty raw -echo

echo "~STATE: in bootstrap"

# The BSD's bash builtin `read` has -e flag that adds the support for readline
# Without that, on BSD bash's `read` reads input in bigger chunks and discards characters
# read in the same chunk after /n character.
# With -e flag, BSD bash's `read` reads input char-by-char which is the same as dash's read (like Ubuntu).
# At the same time dash's `read` doesn't have -e flag so we need to check if the flag is supported.
# Done to fix TBX-12728
if (echo "a" | read -e -n 0 2> /dev/null); then
  read_cmd="read -e -r"
else
  read_cmd="read -r"
fi

content=""
while IFS= $read_cmd line; do
  # echo "~DEBUG: one line received: >>>$line<<<" >&2
  case "$line" in
    "~END BOOTSTRAP"*) break ;;

    # let's write binary data with printf
    # printf supports \ooo format to output a single byte
    # we need to append X at the end of command substitution $(...)
    # the reason is that command substitution trims trailing new line (imagine debugging this problem...)
    # https://stackoverflow.com/questions/15184358/how-to-avoid-bash-command-substitution-to-remove-the-newline-character
    *) content="$content$(printf '%b%s' "$line" "X")" ; content="${content%X}" ;;
  esac
done

echo "~STATE: executing deploy script"
eval "$content"

# Alternative implementation based on files, sometimes useful to debug shell issues
#
# temp="$(mktemp)"
# echo "~DEBUG: reading line"
# while IFS= read -r line; do
#      # printf supports \ooo format to output a single byte
#  case "$line" in
#    "~END BOOTSTRAP"*) break ;;
#    # let's write binary data with printf
#    *) printf "$line" >>"$temp" ;;
#  esac
# done
#
# echo "~STATE: executing deploy script"
# echo ">>>"
# cat "$temp"
# echo "<<<"
# . "$temp"
