/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.resource.jvm;

import com.jetbrains.toolbox.platform.resource.ResourceReader;
import com.jetbrains.toolbox.platform.resource.jvm.JvmResourceReaderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/toolbox/platform/resource/jvm/JvmResourceReader;", "Lcom/jetbrains/toolbox/platform/resource/ResourceReader;", "classLoader", "Ljava/lang/ClassLoader;", "resourcePathPrefix", "", "<init>", "(Ljava/lang/ClassLoader;Ljava/lang/String;)V", "readBytes", "", "resourcePath", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "resource"})
final class JvmResourceReader
implements ResourceReader {
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final String resourcePathPrefix;

    public JvmResourceReader(@NotNull ClassLoader classLoader, @NotNull String resourcePathPrefix) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)resourcePathPrefix, (String)"resourcePathPrefix");
        this.classLoader = classLoader;
        this.resourcePathPrefix = resourcePathPrefix;
    }

    @Override
    @Nullable
    public byte[] readBytes(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        return JvmResourceReaderKt.access$tryReadBytes(this.classLoader, this.resourcePathPrefix + resourcePath);
    }

    private final ClassLoader component1() {
        return this.classLoader;
    }

    private final String component2() {
        return this.resourcePathPrefix;
    }

    @NotNull
    public final JvmResourceReader copy(@NotNull ClassLoader classLoader, @NotNull String resourcePathPrefix) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)resourcePathPrefix, (String)"resourcePathPrefix");
        return new JvmResourceReader(classLoader, resourcePathPrefix);
    }

    public static /* synthetic */ JvmResourceReader copy$default(JvmResourceReader jvmResourceReader, ClassLoader classLoader, String string, int n, Object object) {
        if ((n & 1) != 0) {
            classLoader = jvmResourceReader.classLoader;
        }
        if ((n & 2) != 0) {
            string = jvmResourceReader.resourcePathPrefix;
        }
        return jvmResourceReader.copy(classLoader, string);
    }

    @NotNull
    public String toString() {
        return "JvmResourceReader(classLoader=" + this.classLoader + ", resourcePathPrefix=" + this.resourcePathPrefix + ")";
    }

    public int hashCode() {
        int result = this.classLoader.hashCode();
        result = result * 31 + this.resourcePathPrefix.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmResourceReader)) {
            return false;
        }
        JvmResourceReader jvmResourceReader = (JvmResourceReader)other;
        if (!Intrinsics.areEqual((Object)this.classLoader, (Object)jvmResourceReader.classLoader)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.resourcePathPrefix, (Object)jvmResourceReader.resourcePathPrefix);
    }
}

