/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.client.id;

import com.jetbrains.fus.reporting.client.id.DigestUtil;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\r\u0010\u0016\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/fus/reporting/client/id/DigestUtil;", "", "()V", "HEX_ARRAY", "", "sha2_256", "Ljava/security/MessageDigest;", "getSha2_256", "()Ljava/security/MessageDigest;", "sha2_256$delegate", "Lkotlin/Lazy;", "sunSecurityProvider", "Ljava/security/Provider;", "bytesToHex", "", "data", "", "bytesToHex$id_generation", "cloneDigest", "digest", "getMessageDigest", "algorithm", "sha256", "sha256$id_generation", "id-generation"})
public final class DigestUtil {
    @NotNull
    public static final DigestUtil INSTANCE = new DigestUtil();
    @NotNull
    private static final Provider sunSecurityProvider;
    @NotNull
    private static final Lazy sha2_256$delegate;
    @NotNull
    private static final char[] HEX_ARRAY;

    private DigestUtil() {
    }

    private final MessageDigest getMessageDigest(String algorithm) {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm, sunSecurityProvider);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(algorithm, sunSecurityProvider)");
        return messageDigest;
    }

    private final MessageDigest getSha2_256() {
        Lazy lazy = sha2_256$delegate;
        return (MessageDigest)lazy.getValue();
    }

    private final MessageDigest cloneDigest(MessageDigest digest) {
        try {
            Object object = digest.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.MessageDigest");
            return (MessageDigest)object;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Message digest is not cloneable: " + digest);
        }
    }

    @NotNull
    public final MessageDigest sha256$id_generation() {
        return this.cloneDigest(this.getSha2_256());
    }

    @NotNull
    public final String bytesToHex$id_generation(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int l = data.length;
        char[] chars = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            byte v = data[i];
            chars[j++] = HEX_ARRAY[(0xF0 & v) >>> 4];
            chars[j++] = HEX_ARRAY[0xF & v];
        }
        return new String(chars);
    }

    public static final /* synthetic */ MessageDigest access$getMessageDigest(DigestUtil $this, String algorithm) {
        return $this.getMessageDigest(algorithm);
    }

    static {
        Provider provider = Security.getProvider("SUN");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"getProvider(\"SUN\")");
        sunSecurityProvider = provider;
        sha2_256$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)sha2_256.2.INSTANCE);
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HEX_ARRAY = cArray;
    }
}

