/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.keychain;

import com.jetbrains.keychain.KeychainBackend;
import com.jetbrains.keychain.interop.CREDENTIAL;
import com.jetbrains.keychain.interop.CloseableMemoryKt;
import com.jetbrains.keychain.interop.CredAdvapi32;
import com.jetbrains.keychain.interop.PCREDENTIAL;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0006\u0010\u001c\u001a\u00020\nJ \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lcom/jetbrains/keychain/WindowsKeychainBackend;", "Lcom/jetbrains/keychain/KeychainBackend;", "()V", "isAvailable", "", "()Z", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "name", "", "getName", "()Ljava/lang/String;", "buildCred", "Lcom/jetbrains/keychain/interop/CREDENTIAL;", "key", "username", "credentialBlob", "", "comment", "getKey", "service", "id", "getPassword", "account", "gunzip", "payload", "gzip", "runWhoAmI", "setPassword", "", "password", "keychain"})
public final class WindowsKeychainBackend
implements KeychainBackend {
    private final Logger logger = LoggerFactory.getLogger(WindowsKeychainBackend.class);
    @NotNull
    private final String name;

    public WindowsKeychainBackend() {
        this.name = "windows-system";
    }

    @Override
    public boolean isAvailable() {
        return Platform.isWindows();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getPassword(@NotNull String service, @NotNull String account) {
        String string;
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        String key = this.getKey(service, account);
        PCREDENTIAL pCredential = new PCREDENTIAL();
        try {
            String string2;
            boolean read = CredAdvapi32.Companion.getINSTANCE().CredRead(key, 1, 0, pCredential);
            if (read) {
                byte[] byArray;
                byte[] secretBytes;
                Pointer pointer = pCredential.credential;
                Intrinsics.checkNotNull((Object)pointer);
                CREDENTIAL credential = new CREDENTIAL(pointer);
                Pointer pointer2 = credential.CredentialBlob;
                byte[] byArray2 = secretBytes = pointer2 == null ? null : pointer2.getByteArray(0L, credential.CredentialBlobSize);
                if (secretBytes != null) {
                    WString wString = credential.Comment;
                    if (Intrinsics.areEqual((Object)"gzip", (Object)(wString == null ? null : wString.toString()))) {
                        secretBytes = this.gunzip(secretBytes);
                    }
                }
                string2 = (byArray = secretBytes) == null ? null : new String(byArray, Charsets.UTF_8);
            } else {
                this.logger.debug("Can't get credentials for " + key + ": " + Kernel32Util.getLastErrorMessage());
                string2 = null;
            }
            string = string2;
        }
        catch (Throwable e) {
            this.logger.error("Failed to get credentials", e);
            string = null;
        }
        finally {
            Pointer pointer = pCredential.credential;
            if (pointer != null) {
                Pointer it = pointer;
                boolean bl = false;
                CredAdvapi32.Companion.getINSTANCE().CredFree(it);
            }
        }
        return string;
    }

    @Override
    public void setPassword(@NotNull String service, @NotNull String account, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String key = this.getKey(service, account);
        if (((CharSequence)password).length() == 0) {
            this.logger.debug("Provided password is empty. About to remove credentials for " + key + ".");
            try {
                if (CredAdvapi32.Companion.getINSTANCE().CredDelete(key, 1, 0)) {
                    this.logger.debug("Credentials removed");
                } else {
                    this.logger.error("Failed to remove credentials for " + key + " => [whoami: " + this.runWhoAmI() + "] " + Kernel32.INSTANCE.GetLastError() + ": " + Kernel32Util.getLastErrorMessage());
                }
            }
            catch (Throwable t) {
                this.logger.error("Failed to remove credentials", t);
            }
            return;
        }
        String string = password;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] credentialBlob = byArray;
        String comment = null;
        if (credentialBlob.length > 2560) {
            this.logger.debug("Password size exceeds max credential bytes size: " + credentialBlob.length + " vs 2560, using gzip...");
            credentialBlob = this.gzip(credentialBlob);
            this.logger.debug("Compressed password size: " + credentialBlob.length + " (max: 2560)");
            comment = "gzip";
        }
        CREDENTIAL cred = this.buildCred(key, account, credentialBlob, comment);
        try {
            if (CredAdvapi32.Companion.getINSTANCE().CredWrite(cred, 0)) {
                this.logger.debug("Credentials for " + key + " successfully set");
            } else {
                this.logger.debug("Failed to set credentials for " + key + " => [whoami: " + this.runWhoAmI() + "] " + Kernel32.INSTANCE.GetLastError() + ": " + Kernel32Util.getLastErrorMessage());
            }
        }
        catch (Throwable t) {
            this.logger.error("Failed to set credentials", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String runWhoAmI() {
        Object object = new String[]{"whoami"};
        Process process = new ProcessBuilder((String)object).start();
        process.waitFor();
        Closeable closeable = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)closeable, (String)"process.inputStream");
        Object object2 = Charsets.UTF_8;
        Object object3 = new InputStreamReader((InputStream)closeable, (Charset)object2);
        int n = 8192;
        closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
        object2 = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object3 = it.readLine();
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        object = object3;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"process.inputStream.buff\u2026r().use { it.readLine() }");
        return object;
    }

    private final byte[] gzip(byte[] payload) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gzipOutputStream.write(payload);
        gzipOutputStream.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        return byArray;
    }

    private final byte[] gunzip(byte[] payload) {
        byte[] byArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(payload);
        GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);
        try {
            byArray = gzipInputStream.readAllBytes();
        }
        catch (ZipException e) {
            byArray = null;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final CREDENTIAL buildCred(String key, String username, byte[] credentialBlob, String comment) {
        WString wString;
        CREDENTIAL credential = new CREDENTIAL();
        credential.Flags = 0;
        credential.Type = 1;
        credential.TargetName = new WString(key);
        CREDENTIAL cREDENTIAL = credential;
        String string = comment;
        if (string == null) {
            wString = null;
        } else {
            void it;
            String string2 = string;
            CREDENTIAL cREDENTIAL2 = cREDENTIAL;
            boolean bl = false;
            wString = new WString((String)it);
            cREDENTIAL = cREDENTIAL2;
        }
        cREDENTIAL.Comment = wString;
        credential.CredentialBlobSize = credentialBlob.length;
        credential.CredentialBlob = (Pointer)CloseableMemoryKt.byteArrayPointer(credentialBlob);
        credential.Persist = 2;
        credential.UserName = new WString(username);
        return credential;
    }

    static /* synthetic */ CREDENTIAL buildCred$default(WindowsKeychainBackend windowsKeychainBackend, String string, String string2, byte[] byArray, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return windowsKeychainBackend.buildCred(string, string2, byArray, string3);
    }

    private final String getKey(String service, String id) {
        return service + "-" + id;
    }
}

