/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.entry;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ToolboxProcessEarlyEntry {
    static Runnable openWindowHandler;
    public static final long earliestTimestamp;
    public static boolean startupTimeReported;

    public static int startToolbox(String[] args) {
        try {
            Path libDirectory = Paths.get(System.getProperty("toolbox.jars.path"), new String[0]);
            if (!Files.isDirectory(libDirectory, new LinkOption[0])) {
                throw new RuntimeException("Expected 'lib' directory does not exist at: " + String.valueOf(libDirectory));
            }
            Path pluginApiJarsDirectory = libDirectory.resolve("pluginApi");
            if (!Files.isDirectory(pluginApiJarsDirectory, new LinkOption[0])) {
                throw new RuntimeException("Expected 'pluginApi' directory does not exist at: " + String.valueOf(pluginApiJarsDirectory));
            }
            Path allJarsDirectory = libDirectory.resolve("all");
            if (!Files.isDirectory(allJarsDirectory, new LinkOption[0])) {
                throw new RuntimeException("Expected 'all' directory does not exist at: " + String.valueOf(allJarsDirectory));
            }
            URLClassLoader pluginApiClassLoader = new URLClassLoader(ToolboxProcessEarlyEntry.getJarURLs(pluginApiJarsDirectory, path -> true), ToolboxProcessEarlyEntry.class.getClassLoader());
            ArrayList<URL> otherUrls = new ArrayList<URL>();
            String hotClassesProperty = System.getProperty("hot.classes");
            if (hotClassesProperty != null) {
                otherUrls.add(new File(hotClassesProperty).toURI().toURL());
            }
            otherUrls.addAll(Arrays.asList(ToolboxProcessEarlyEntry.getJarURLs(allJarsDirectory, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]))));
            URLClassLoader allOtherClassLoader = new URLClassLoader(otherUrls.toArray(new URL[0]), (ClassLoader)pluginApiClassLoader);
            String entryClassName = Arrays.stream(args).anyMatch(s -> s.equalsIgnoreCase("--frontend")) ? "com.jetbrains.toolbox.entry.ToolboxFrontendEntry" : (Arrays.stream(args).anyMatch(s -> s.equalsIgnoreCase("--mcp")) ? "com.jetbrains.toolbox.feature.mcp.proxy.ToolboxMcpEntry" : "com.jetbrains.toolbox.entry.ToolboxEntry");
            Class<?> entry = allOtherClassLoader.loadClass(entryClassName);
            Method startToolbox = entry.getMethod("startToolboxMain", String[].class, ClassLoader.class);
            Boolean shouldExitAfterStart = (Boolean)startToolbox.invoke(entry, args, pluginApiClassLoader);
            if (shouldExitAfterStart == null) {
                return 2;
            }
            if (shouldExitAfterStart.booleanValue()) {
                return 1;
            }
            Method getOpenWindowHandler = entry.getMethod("getOpenWindowHandler", new Class[0]);
            openWindowHandler = (Runnable)getOpenWindowHandler.invoke(entry, new Object[0]);
            return 0;
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static void openWindow() {
        openWindowHandler.run();
    }

    static URL mapToUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static URL[] getJarURLs(Path directory, Predicate<Path> predicate) throws IOException {
        try (Stream<Path> files = Files.list(directory);){
            URL[] uRLArray = (URL[])files.filter(predicate).map(Path::toUri).map(ToolboxProcessEarlyEntry::mapToUrl).filter(filename -> filename.toString().endsWith(".jar")).distinct().toArray(URL[]::new);
            return uRLArray;
        }
    }

    static {
        earliestTimestamp = System.nanoTime();
        startupTimeReported = false;
    }
}

