/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.regex.Pattern;
import org.freedesktop.dbus.annotations.DBusInterfaceName;
import org.freedesktop.dbus.annotations.DBusMemberName;

public final class DBusNamingUtil {
    private static final Pattern DOLLAR_PATTERN = Pattern.compile("[$]");

    private DBusNamingUtil() {
    }

    public static String getInterfaceName(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        if (clazz.isAnnotationPresent(DBusInterfaceName.class)) {
            return clazz.getAnnotation(DBusInterfaceName.class).value();
        }
        return DOLLAR_PATTERN.matcher(clazz.getName()).replaceAll(".");
    }

    public static String getMethodName(Method method) {
        Objects.requireNonNull(method, "method must not be null");
        if (method.isAnnotationPresent(DBusMemberName.class)) {
            return method.getAnnotation(DBusMemberName.class).value();
        }
        return method.getName();
    }

    public static String getSignalName(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        if (clazz.isAnnotationPresent(DBusMemberName.class)) {
            return clazz.getAnnotation(DBusMemberName.class).value();
        }
        return clazz.getSimpleName();
    }

    public static String getAnnotationName(Class<? extends Annotation> clazz) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        if (clazz.isAnnotationPresent(DBusInterfaceName.class)) {
            return clazz.getAnnotation(DBusInterfaceName.class).value();
        }
        return DOLLAR_PATTERN.matcher(clazz.getName()).replaceAll(".");
    }
}

