/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.browser.firefox;

import com.github.markusbernhardt.proxy.search.browser.firefox.FirefoxProfileSource;
import com.github.markusbernhardt.proxy.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import org.ini4j.Ini;
import org.ini4j.Profile;

class FirefoxSettingParser {
    public Properties parseSettings(FirefoxProfileSource source) throws IOException {
        File settingsFile = this.getSettingsFile(source);
        Properties result = new Properties();
        if (settingsFile == null) {
            return result;
        }
        try (BufferedReader fin = new BufferedReader(new InputStreamReader(new FileInputStream(settingsFile)));){
            String line;
            while ((line = fin.readLine()) != null) {
                if (!(line = line.trim()).startsWith("user_pref(\"network.proxy")) continue;
                line = line.substring(10, line.length() - 2);
                int index = line.indexOf(",");
                String key = this.removeDoubleQuotes(line.substring(0, index).trim());
                String value = this.removeDoubleQuotes(line.substring(index + 1).trim());
                result.put(key, value);
            }
        }
        return result;
    }

    private String removeDoubleQuotes(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private File getSettingsFile(FirefoxProfileSource source) throws IOException {
        File profilesIniFile = source.getProfilesIni();
        if (profilesIniFile.exists()) {
            Ini profilesIni = new Ini(profilesIniFile);
            for (Map.Entry entry : profilesIni.entrySet()) {
                if (!"default".equals(((Profile.Section)entry.getValue()).get((Object)"Name")) || !"1".equals(((Profile.Section)entry.getValue()).get((Object)"IsRelative"))) continue;
                File profileFolder = new File(profilesIniFile.getParentFile().getAbsolutePath(), (String)((Profile.Section)entry.getValue()).get((Object)"Path"));
                Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox settings folder is {}", profileFolder);
                File settingsFile = new File(profileFolder, "prefs.js");
                return settingsFile;
            }
        }
        Logger.log(this.getClass(), Logger.LogLevel.DEBUG, "Firefox settings folder not found!", new Object[0]);
        return null;
    }
}

