/*
 * Decompiled with CFR 0.152.
 */
package runtime.net;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import libraries.collections.MultiMap;
import libraries.collections.MultiMapKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.net.EncodingKt;
import runtime.net.UriKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bJ\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\bJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bJ\u001f\u0010\u0012\u001a\u00020\b2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0016\"\u00020\b\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0012\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lruntime/net/Uri;", "", "<init>", "()V", "FRAGMENT_SEPARATOR", "", "QUERY_SEPARATOR", "buildUrl", "", "path", "queryParameters", "", "parseQuery", "Llibraries/collections/MultiMap;", "query", "extractQuery", "uriString", "stripQuery", "combineUrls", "baseUrl", "toAdd", "urls", "", "([Ljava/lang/String;)Ljava/lang/String;", "", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nUri.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Uri.kt\nruntime/net/Uri\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,76:1\n1317#2,2:77\n*S KotlinDebug\n*F\n+ 1 Uri.kt\nruntime/net/Uri\n*L\n33#1:77,2\n*E\n"})
public final class Uri {
    @NotNull
    public static final Uri INSTANCE = new Uri();
    private static final char FRAGMENT_SEPARATOR = '#';
    private static final char QUERY_SEPARATOR = '?';

    private Uri() {
    }

    @NotNull
    public final String buildUrl(@NotNull String path, @NotNull Map<String, String> queryParameters) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(queryParameters, (String)"queryParameters");
        String query2 = SequencesKt.joinToString$default((Sequence)SequencesKt.mapNotNull((Sequence)MapsKt.asSequence(queryParameters), Uri::buildUrl$lambda$1), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        return ((CharSequence)query2).length() > 0 ? (StringsKt.contains$default((CharSequence)query2, (char)'?', (boolean)false, (int)2, null) ? path + "&" + query2 : path + "?" + query2) : path;
    }

    @NotNull
    public final MultiMap<String, String> parseQuery(@NotNull String query2) {
        MultiMap multiMap;
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        MultiMap $this$parseQuery_u24lambda_u243 = multiMap = MultiMapKt.linkedMultiMap$default(null, 1, null);
        boolean bl = false;
        char[] cArray = new char[]{'&'};
        Sequence $this$forEach$iv = StringsKt.splitToSequence$default((CharSequence)query2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            String name = EncodingKt.urlDecode(StringsKt.substringBefore$default((String)it, (String)"=", null, (int)2, null));
            String value2 = EncodingKt.urlDecode(StringsKt.substringAfter((String)it, (String)"=", (String)""));
            $this$parseQuery_u24lambda_u243.put(name, value2);
        }
        return multiMap;
    }

    @Nullable
    public final String extractQuery(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        Pair prefixFragment = UriKt.access$splitOnLast(uriString, '#');
        Pair prefixQuery = UriKt.access$splitOnLast((String)prefixFragment.getFirst(), '?');
        return (String)prefixQuery.getSecond();
    }

    @NotNull
    public final String stripQuery(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        return StringsKt.substringBefore$default((String)uriString, (char)'?', null, (int)2, null);
    }

    @NotNull
    public final String combineUrls(@NotNull String baseUrl, @NotNull String toAdd) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)toAdd, (String)"toAdd");
        CharSequence charSequence = baseUrl;
        Regex regex = new Regex("/+$");
        String string = "";
        String string2 = regex.replace(charSequence, string);
        charSequence = toAdd;
        regex = new Regex("^/+");
        string = "";
        return string2 + "/" + regex.replace(charSequence, string);
    }

    @NotNull
    public final String combineUrls(String ... urls) {
        Intrinsics.checkNotNullParameter((Object)urls, (String)"urls");
        return this.combineUrls(ArraysKt.toList((Object[])urls));
    }

    @NotNull
    public final String combineUrls(@NotNull List<String> urls) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        if (urls.isEmpty()) {
            throw new Error("urls must not be empty");
        }
        String base = urls.get(0);
        int n = urls.size();
        for (int i = 1; i < n; ++i) {
            base = this.combineUrls(base, urls.get(i));
        }
        return base;
    }

    private static final String buildUrl$lambda$1(Map.Entry queryParameter) {
        String string;
        Intrinsics.checkNotNullParameter((Object)queryParameter, (String)"queryParameter");
        String string2 = (String)queryParameter.getValue();
        if (string2 != null) {
            String value2 = string2;
            boolean bl = false;
            string = queryParameter.getKey() + "=" + EncodingKt.urlEncode(value2);
        } else {
            string = null;
        }
        return string;
    }
}

