/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.channels;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Llibraries/io/channels/BufferedReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "delegate", "byteBuffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/nio/channels/ReadableByteChannel;Ljava/nio/ByteBuffer;)V", "bufferRead", "Ljava/util/concurrent/atomic/AtomicBoolean;", "bufferArray", "", "close", "", "isOpen", "", "read", "", "dst", "libraries-io"})
public final class BufferedReadableByteChannel
implements ReadableByteChannel {
    @NotNull
    private final ReadableByteChannel delegate;
    @NotNull
    private final ByteBuffer byteBuffer;
    @NotNull
    private final AtomicBoolean bufferRead;
    @NotNull
    private final byte[] bufferArray;

    public BufferedReadableByteChannel(@NotNull ReadableByteChannel delegate, @NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        this.delegate = delegate;
        this.byteBuffer = byteBuffer;
        int readBytes = this.delegate.read(this.byteBuffer);
        this.bufferArray = new byte[Math.max(readBytes, 0)];
        this.byteBuffer.flip();
        this.byteBuffer.get(this.bufferArray);
        this.bufferRead = new AtomicBoolean(this.bufferArray.length == 0);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isOpen() {
        return !this.bufferRead.get() || this.delegate.isOpen();
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        int n;
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (this.bufferRead.compareAndSet(false, true)) {
            dst.put(this.bufferArray);
            n = this.bufferArray.length;
        } else {
            n = this.delegate.read(dst);
        }
        return n;
    }
}

