/*
 * Decompiled with CFR 0.152.
 */
package libraries.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0010\u001a\n\u0018\u00010\u0012j\u0004\u0018\u0001`\u0011\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0015"}, d2={"Llibraries/io/FSLock;", "", "lockFile", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "getLockFile", "()Ljava/io/File;", "lockOrNull", "T", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isLocked", "", "()Z", "getLock", "Lkotlin/AutoCloseable;", "Ljava/lang/AutoCloseable;", "()Ljava/lang/AutoCloseable;", "Companion", "libraries-io"})
@SourceDebugExtension(value={"SMAP\nFSLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSLock.kt\nlibraries/io/FSLock\n*L\n1#1,83:1\n15#1,2:84\n*S KotlinDebug\n*F\n+ 1 FSLock.kt\nlibraries/io/FSLock\n*L\n22#1:84,2\n*E\n"})
public final class FSLock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File lockFile;
    private static final Logger LOG = LoggerFactory.getLogger(FSLock.class);
    private static final Set<String> locks = Collections.synchronizedSet(new HashSet());

    public FSLock(@NotNull File lockFile) {
        Intrinsics.checkNotNullParameter((Object)lockFile, (String)"lockFile");
        this.lockFile = lockFile;
    }

    @NotNull
    public final File getLockFile() {
        return this.lockFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T lockOrNull(@NotNull Function0<? extends T> body) {
        Object object;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$lockOrNull = false;
        AutoCloseable autoCloseable = this.getLock();
        if (autoCloseable != null) {
            AutoCloseable autoCloseable2 = autoCloseable;
            Throwable throwable = null;
            try {
                AutoCloseable it = autoCloseable2;
                boolean bl = false;
                Object object2 = body.invoke();
                object = object2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
        } else {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLocked() {
        Unit unit;
        if (!this.lockFile.exists()) return false;
        FSLock this_$iv = this;
        boolean $i$f$lockOrNull = false;
        AutoCloseable autoCloseable = this_$iv.getLock();
        if (autoCloseable == null) return true;
        AutoCloseable autoCloseable2 = autoCloseable;
        Throwable throwable = null;
        try {
            AutoCloseable it$iv = autoCloseable2;
            boolean bl = false;
            boolean bl2 = false;
            Unit unit2 = Unit.INSTANCE;
            unit = unit2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
        }
        if (unit != null) return false;
        return true;
    }

    @Nullable
    public final AutoCloseable getLock() {
        String path = this.lockFile.getAbsolutePath();
        try {
            if (!locks.add(path)) {
                return null;
            }
            if (!this.lockFile.getParentFile().exists()) {
                throw new FileNotFoundException("Directory for lock file " + path + " not found");
            }
            Object[] objectArray = new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.SYNC};
            FileChannel channel2 = FileChannel.open(this.lockFile.toPath(), SetsKt.setOf((Object[])objectArray), new FileAttribute[0]);
            FileLock lock = channel2.tryLock();
            if (lock == null) {
                try {
                    channel2.close();
                }
                catch (Throwable e) {
                    LOG.error("Closing lock " + path, e);
                }
                locks.remove(path);
                return null;
            }
            return new AutoCloseable(lock, channel2, this, path){
                final /* synthetic */ FileLock $lock$inlined;
                final /* synthetic */ FileChannel $channel$inlined;
                final /* synthetic */ FSLock this$0;
                final /* synthetic */ String $path$inlined;
                {
                    this.$lock$inlined = fileLock;
                    this.$channel$inlined = fileChannel;
                    this.this$0 = fSLock;
                    this.$path$inlined = string;
                }

                public final void close() {
                    boolean bl = false;
                    try {
                        this.$lock$inlined.release();
                        this.$channel$inlined.close();
                        this.this$0.getLockFile().delete();
                    }
                    catch (Throwable e) {
                        FSLock.access$getLOG$cp().error("Closing lock " + this.$path$inlined, e);
                    }
                    FSLock.access$getLocks$cp().remove(this.$path$inlined);
                }
            };
        }
        catch (OverlappingFileLockException e) {
            locks.remove(path);
            return null;
        }
        catch (IOException e) {
            locks.remove(path);
            return null;
        }
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Set access$getLocks$cp() {
        return locks;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R4\u0010\b\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\r"}, d2={"Llibraries/io/FSLock$Companion;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "locks", "", "", "", "Ljava/util/Set;", "libraries-io"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

