/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.ProfileIdentifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcirclet/client/api/ProfileIdentifierResolver;", "", "<init>", "()V", "usernamePrefix", "", "idPrefix", "resolve", "Lcirclet/client/api/ProfileIdentifier;", "profileAsString", "spaceport-client-api"})
public final class ProfileIdentifierResolver {
    @NotNull
    public static final ProfileIdentifierResolver INSTANCE = new ProfileIdentifierResolver();
    @NotNull
    private static final String usernamePrefix = "username:";
    @NotNull
    private static final String idPrefix = "id:";

    private ProfileIdentifierResolver() {
    }

    @NotNull
    public final ProfileIdentifier resolve(@NotNull String profileAsString) {
        ProfileIdentifier profileIdentifier;
        Intrinsics.checkNotNullParameter((Object)profileAsString, (String)"profileAsString");
        if (StringsKt.equals((String)profileAsString, (String)"me", (boolean)true) || StringsKt.equals((String)profileAsString, (String)"my", (boolean)true)) {
            profileIdentifier = ProfileIdentifier.Me.INSTANCE;
        } else if (StringsKt.startsWith((String)profileAsString, (String)usernamePrefix, (boolean)true)) {
            String string = profileAsString.substring(usernamePrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            profileIdentifier = new ProfileIdentifier.Username(string);
        } else if (StringsKt.startsWith((String)profileAsString, (String)idPrefix, (boolean)true)) {
            String string = profileAsString.substring(idPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            profileIdentifier = new ProfileIdentifier.Id(string);
        } else {
            profileIdentifier = new ProfileIdentifier.Id(profileAsString);
        }
        return profileIdentifier;
    }
}

