/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsCommitExternalStatus;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogDataKt;
import com.intellij.vcs.log.data.util.VcsCommitsDataLoader;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.details.CommitDetailsListPanel;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.frame.CommitDetailsLoader;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusPresentation;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0007\b\u0007\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u00040123B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\u00142\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u0018j\u0002`\u00190\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\b\u0010 \u001a\u00020\u0014H\u0016J\b\u0010!\u001a\u00020\u0014H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0016J\u0015\u0010%\u001a\u00020\u00142\u000b\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(H\u0002J*\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00172\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020'0-H\u0002J\b\u0010.\u001a\u00020\u0014H\u0002J\b\u0010/\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails;", "Lcom/intellij/vcs/log/ui/frame/CommitDetailsLoader$Listener;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "Lcom/intellij/openapi/Disposable;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "parentDisposable", "<init>", "(Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/ui/VcsLogColorManager;Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;Lcom/intellij/openapi/Disposable;)V", "hashesResolver", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$CommitDataLoader;", "containingBranchesLoader", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ContainingBranchesAsyncLoader;", "externalStatusesLoader", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader;", "onSelection", "", "onDetailsLoaded", "hashedCommitsIds", "", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "details", "sortRefs", "Lcom/intellij/vcs/log/VcsRef;", "refs", "", "onEmptySelection", "onLoadingStarted", "onLoadingStopped", "onError", "error", "", "setEmpty", "text", "", "Lorg/jetbrains/annotations/Nls;", "doResolveHashes", "Lcom/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation;", "presentations", "unResolvedHashes", "", "cancelLoading", "dispose", "CommitDataLoader", "ContainingBranchesAsyncLoader", "ExternalStatusesAsyncLoader", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogCommitSelectionListenerForDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogCommitSelectionListenerForDetails.kt\ncom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n1563#2:303\n1634#2,3:304\n1563#2:307\n1634#2,3:308\n774#2:311\n865#2,2:312\n1563#2:314\n1634#2,3:315\n*S KotlinDebug\n*F\n+ 1 VcsLogCommitSelectionListenerForDetails.kt\ncom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails\n*L\n51#1:303\n51#1:304,3\n56#1:307\n56#1:308,3\n113#1:311\n113#1:312,2\n137#1:314\n137#1:315,3\n*E\n"})
public final class VcsLogCommitSelectionListenerForDetails
implements CommitDetailsLoader.Listener<VcsCommitMetadata>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final VcsLogColorManager colorManager;
    @NotNull
    private final CommitDetailsListPanel detailsPanel;
    @NotNull
    private final CommitDataLoader hashesResolver;
    @NotNull
    private final ContainingBranchesAsyncLoader containingBranchesLoader;
    @NotNull
    private final ExternalStatusesAsyncLoader externalStatusesLoader;
    public static final int MAX_COMMITS_TO_LOAD = 50;

    public VcsLogCommitSelectionListenerForDetails(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull CommitDetailsListPanel detailsPanel, @NotNull Disposable parentDisposable) {
        Object it;
        Object object;
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter((Object)colorManager, (String)"colorManager");
        Intrinsics.checkNotNullParameter((Object)((Object)detailsPanel), (String)"detailsPanel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.logData = logData;
        this.colorManager = colorManager;
        this.detailsPanel = detailsPanel;
        this.hashesResolver = new CommitDataLoader();
        ContainingBranchesAsyncLoader containingBranchesAsyncLoader = object = new ContainingBranchesAsyncLoader(this.logData.getContainingBranchesGetter(), this.detailsPanel);
        VcsLogCommitSelectionListenerForDetails vcsLogCommitSelectionListenerForDetails = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)it);
        vcsLogCommitSelectionListenerForDetails.containingBranchesLoader = object;
        it = object = new ExternalStatusesAsyncLoader(this.logData.getProject(), this.detailsPanel);
        vcsLogCommitSelectionListenerForDetails = this;
        boolean bl2 = false;
        Disposer.register((Disposable)this, (Disposable)it);
        vcsLogCommitSelectionListenerForDetails.externalStatusesLoader = object;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @Override
    public void onSelection() {
        this.cancelLoading();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onDetailsLoaded(@NotNull List<Integer> hashedCommitsIds, @NotNull List<? extends VcsCommitMetadata> details) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(hashedCommitsIds, (String)"hashedCommitsIds");
        Intrinsics.checkNotNullParameter(details, (String)"details");
        List detailsList = CollectionsKt.take((Iterable)details, (int)50);
        Iterable $this$map$iv = detailsList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CommitId((Hash)it.getId(), it.getRoot()));
        }
        List commitIds2 = (List)destination$iv$iv;
        this.detailsPanel.rebuildPanel$intellij_platform_vcs_log_impl(commitIds2);
        this.detailsPanel.showOverflowLabelIfNeeded(50, hashedCommitsIds.size());
        Set unResolvedHashes = new LinkedHashSet();
        Iterable $this$map$iv2 = detailsList;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(CommitPresentationUtil.buildPresentation(this.logData.getProject(), (VcsCommitMetadata)it, unResolvedHashes));
        }
        List presentations = (List)destination$iv$iv2;
        RefsModel refsModel = this.logData.getDataPack().getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
        RefsModel refsModel2 = refsModel;
        this.detailsPanel.forEachPanelIndexed((Function2<? super Integer, ? super CommitDetailsPanel, Unit>)((Function2)(arg_0, arg_1) -> VcsLogCommitSelectionListenerForDetails.onDetailsLoaded$lambda$2(presentations, commitIds2, this, hashedCommitsIds, refsModel2, arg_0, arg_1)));
        ContainingBranchesAsyncLoader.requestData$default(this.containingBranchesLoader, commitIds2, false, 2, null);
        this.externalStatusesLoader.requestData(commitIds2);
        if (!((Collection)unResolvedHashes).isEmpty()) {
            this.hashesResolver.loadData(arg_0 -> VcsLogCommitSelectionListenerForDetails.onDetailsLoaded$lambda$3(this, presentations, unResolvedHashes, arg_0), VcsLogCommitSelectionListenerForDetails::onDetailsLoaded$lambda$4);
        }
    }

    private final List<VcsRef> sortRefs(Collection<? extends VcsRef> refs) {
        VcsRef vcsRef = (VcsRef)CollectionsKt.firstOrNull((Iterable)refs);
        if (vcsRef == null || (vcsRef = vcsRef.getRoot()) == null) {
            return CollectionsKt.emptyList();
        }
        VcsRef root = vcsRef;
        Iterable iterable = refs;
        Comparator comparator = VcsLogDataKt.getLogProvider(this.logData, (VirtualFile)root).getReferenceManager().getLabelsOrderComparator();
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"getLabelsOrderComparator(...)");
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    @Override
    public void onEmptySelection() {
        this.cancelLoading();
        String string = VcsLogBundle.message("vcs.log.changes.details.no.commits.selected.status", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setEmpty(string);
    }

    @Override
    public void onLoadingStarted() {
        this.detailsPanel.startLoadingDetails();
    }

    @Override
    public void onLoadingStopped() {
        this.detailsPanel.stopLoadingDetails();
    }

    @Override
    public void onError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        String string = VcsLogBundle.message("vcs.log.error.loading.details.status", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setEmpty(string);
    }

    private final void setEmpty(String text) {
        this.detailsPanel.setStatusText(text);
        this.detailsPanel.rebuildPanel$intellij_platform_vcs_log_impl(CollectionsKt.emptyList());
        this.detailsPanel.showOverflowLabelIfNeeded(50, 0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CommitPresentationUtil.CommitPresentation> doResolveHashes(List<? extends CommitPresentationUtil.CommitPresentation> presentations, Set<String> unResolvedHashes) {
        void $this$mapTo$iv$iv;
        Object hash;
        Object it;
        void $this$filterTo$iv$iv;
        MultiMap resolvedHashes = new MultiMap();
        Iterable $this$filter$iv = unResolvedHashes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(((String)it).length() == 40)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List fullHashes = (List)destination$iv$iv;
        for (Object e : fullHashes) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String fullHash = (String)e;
            Intrinsics.checkNotNullExpressionValue((Object)HashImpl.build((String)fullHash), (String)"build(...)");
            for (VirtualFile root : VcsLogDataKt.getRoots(this.logData)) {
                CommitId id = new CommitId(hash, root);
                if (!this.logData.getStorage().containsCommit(id)) continue;
                resolvedHashes.putValue((Object)fullHash, (Object)id);
            }
            unResolvedHashes.remove(fullHash);
        }
        if (!((Collection)unResolvedHashes).isEmpty()) {
            this.logData.getStorage().iterateCommits(arg_0 -> VcsLogCommitSelectionListenerForDetails.doResolveHashes$lambda$2(arg_0 -> VcsLogCommitSelectionListenerForDetails.doResolveHashes$lambda$1(unResolvedHashes, resolvedHashes, arg_0), arg_0));
        }
        Iterable $this$map$iv = presentations;
        boolean $i$f$map = false;
        hash = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (CommitPresentationUtil.CommitPresentation)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(((CommitPresentationUtil.CommitPresentation)it).resolve((MultiMap<String, CommitId>)resolvedHashes));
        }
        return (List)destination$iv$iv;
    }

    private final void cancelLoading() {
        this.hashesResolver.cancelLoading();
        ContainingBranchesAsyncLoader.requestData$default(this.containingBranchesLoader, CollectionsKt.emptyList(), false, 2, null);
        this.externalStatusesLoader.requestData(CollectionsKt.emptyList());
    }

    public void dispose() {
        this.cancelLoading();
    }

    private static final Unit onDetailsLoaded$lambda$2(List $presentations, List $commitIds, VcsLogCommitSelectionListenerForDetails this$0, List $hashedCommitsIds, RefsModel $refsModel, int idx, CommitDetailsPanel panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Object e = $presentations.get(idx);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        CommitPresentationUtil.CommitPresentation presentation = (CommitPresentationUtil.CommitPresentation)e;
        panel.setCommit(presentation);
        VirtualFile virtualFile = ((CommitId)$commitIds.get(idx)).getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile root = virtualFile;
        if (this$0.colorManager.hasMultiplePaths()) {
            Color color = this$0.colorManager.getRootColor(root);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getRootColor(...)");
            panel.setRoot(new CommitDetailsPanel.RootColor(root, color));
        } else {
            panel.setRoot(null);
        }
        int id = ((Number)$hashedCommitsIds.get(idx)).intValue();
        List<VcsRef> refs = $refsModel.refsToCommit(root, id);
        panel.setRefs(this$0.sortRefs((Collection<? extends VcsRef>)refs));
        return Unit.INSTANCE;
    }

    private static final List onDetailsLoaded$lambda$3(VcsLogCommitSelectionListenerForDetails this$0, List $presentations, Set $unResolvedHashes, ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.doResolveHashes($presentations, $unResolvedHashes);
    }

    private static final Unit onDetailsLoaded$lambda$4(CommitDetailsPanel panel, CommitPresentationUtil.CommitPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        panel.setCommit(presentation);
        return Unit.INSTANCE;
    }

    private static final boolean doResolveHashes$lambda$1(Set $unResolvedHashes, MultiMap $resolvedHashes, CommitId commitId) {
        Intrinsics.checkNotNullParameter((Object)commitId, (String)"commitId");
        for (String hashString : $unResolvedHashes) {
            String string = commitId.getHash().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            if (!StringsKt.startsWith((String)string, (String)hashString, (boolean)true)) continue;
            $resolvedHashes.putValue((Object)hashString, (Object)commitId);
        }
        return true;
    }

    private static final boolean doResolveHashes$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\n0\t2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\u00070\fJ\u0006\u0010\u000e\u001a\u00020\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$CommitDataLoader;", "", "<init>", "(Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails;)V", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadData", "", "T", "Lkotlin/Function1;", "", "setData", "Lkotlin/Function2;", "Lcom/intellij/vcs/log/ui/details/commit/CommitDetailsPanel;", "cancelLoading", "intellij.platform.vcs.log.impl"})
    private final class CommitDataLoader {
        @Nullable
        private ProgressIndicator progressIndicator;

        public final <T> void loadData(@NotNull Function1<? super ProgressIndicator, ? extends List<? extends T>> loadData, @NotNull Function2<? super CommitDetailsPanel, ? super T, Unit> setData) {
            Intrinsics.checkNotNullParameter(loadData, (String)"loadData");
            Intrinsics.checkNotNullParameter(setData, (String)"setData");
            this.progressIndicator = BackgroundTaskUtil.executeOnPooledThread((Disposable)VcsLogCommitSelectionListenerForDetails.this, () -> CommitDataLoader.loadData$lambda$0(loadData, this, VcsLogCommitSelectionListenerForDetails.this, setData));
        }

        public final void cancelLoading() {
            if (this.progressIndicator != null) {
                ProgressIndicator progressIndicator = this.progressIndicator;
                Intrinsics.checkNotNull((Object)progressIndicator);
                progressIndicator.cancel();
                this.progressIndicator = null;
            }
        }

        private static final void loadData$lambda$0(Function1 $loadData, CommitDataLoader this$0, VcsLogCommitSelectionListenerForDetails this$1, Function2 $setData) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            Intrinsics.checkNotNull((Object)indicator);
            List loaded = (List)$loadData.invoke((Object)indicator);
            ApplicationManager.getApplication().invokeLater(() -> CommitDataLoader.loadData$lambda$0$0(this$0, this$1, $setData, loaded), arg_0 -> CommitDataLoader.loadData$lambda$0$1(indicator, arg_0));
        }

        private static final void loadData$lambda$0$0(CommitDataLoader this$0, VcsLogCommitSelectionListenerForDetails this$1, Function2 $setData, List $loaded) {
            this$0.progressIndicator = null;
            this$1.detailsPanel.forEachPanelIndexed((Function2<? super Integer, ? super CommitDetailsPanel, Unit>)((Function2)(arg_0, arg_1) -> CommitDataLoader.loadData$lambda$0$0$0($setData, $loaded, arg_0, arg_1)));
        }

        private static final Unit loadData$lambda$0$0$0(Function2 $setData, List $loaded, int i, CommitDetailsPanel panel) {
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            $setData.invoke((Object)panel, $loaded.get(i));
            return Unit.INSTANCE;
        }

        private static final boolean loadData$lambda$0$1(ProgressIndicator $indicator, Object it) {
            return $indicator.isCanceled();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$Companion;", "", "<init>", "()V", "MAX_COMMITS_TO_LOAD", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ContainingBranchesAsyncLoader;", "Lcom/intellij/openapi/Disposable;", "getter", "Lcom/intellij/vcs/log/data/ContainingBranchesGetter;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "<init>", "(Lcom/intellij/vcs/log/data/ContainingBranchesGetter;Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;)V", "requestedCommits", "", "Lcom/intellij/vcs/log/CommitId;", "branchesChanged", "", "requestData", "commits", "fromCache", "", "dispose", "intellij.platform.vcs.log.impl"})
    private static final class ContainingBranchesAsyncLoader
    implements Disposable {
        @NotNull
        private final ContainingBranchesGetter getter;
        @NotNull
        private final CommitDetailsListPanel detailsPanel;
        @NotNull
        private List<CommitId> requestedCommits;

        public ContainingBranchesAsyncLoader(@NotNull ContainingBranchesGetter getter, @NotNull CommitDetailsListPanel detailsPanel) {
            Intrinsics.checkNotNullParameter((Object)getter, (String)"getter");
            Intrinsics.checkNotNullParameter((Object)((Object)detailsPanel), (String)"detailsPanel");
            this.getter = getter;
            this.detailsPanel = detailsPanel;
            this.requestedCommits = CollectionsKt.emptyList();
            Runnable containingBranchesListener = () -> ContainingBranchesAsyncLoader._init_$lambda$0(this);
            this.getter.addTaskCompletedListener(containingBranchesListener);
            Disposer.register((Disposable)this, () -> ContainingBranchesAsyncLoader._init_$lambda$1(this, containingBranchesListener));
        }

        private final void branchesChanged() {
            this.requestData(this.requestedCommits, true);
        }

        public final void requestData(@NotNull List<CommitId> commits, boolean fromCache) {
            Intrinsics.checkNotNullParameter(commits, (String)"commits");
            Map result = new LinkedHashMap();
            for (CommitId commit : commits) {
                List<String> branches;
                List<String> list;
                if (fromCache) {
                    VirtualFile virtualFile = commit.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    Hash hash = commit.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
                    list = this.getter.getContainingBranchesFromCache(virtualFile, hash);
                } else {
                    VirtualFile virtualFile = commit.getRoot();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                    Hash hash = commit.getHash();
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
                    list = this.getter.requestContainingBranches(virtualFile, hash);
                }
                if ((branches = list) == null) continue;
                result.put(commit, branches);
            }
            if (!result.isEmpty()) {
                this.detailsPanel.forEachPanel((Function2<? super CommitId, ? super CommitDetailsPanel, Unit>)((Function2)(arg_0, arg_1) -> ContainingBranchesAsyncLoader.requestData$lambda$0(result, arg_0, arg_1)));
            }
            this.requestedCommits = commits;
        }

        public static /* synthetic */ void requestData$default(ContainingBranchesAsyncLoader containingBranchesAsyncLoader, List list, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            containingBranchesAsyncLoader.requestData(list, bl);
        }

        public void dispose() {
        }

        private static final void _init_$lambda$0(ContainingBranchesAsyncLoader this$0) {
            this$0.branchesChanged();
        }

        private static final void _init_$lambda$1(ContainingBranchesAsyncLoader this$0, Runnable $containingBranchesListener) {
            this$0.getter.removeTaskCompletedListener($containingBranchesListener);
        }

        private static final Unit requestData$lambda$0(Map $result, CommitId commit, CommitDetailsPanel panel) {
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            panel.setBranches((List)$result.get(commit));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\nJ\u0012\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\r0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "detailsPanel", "Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;)V", "loadersDisposable", "loaders", "", "Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader$ProviderLoader;", "statuses", "", "Lcom/intellij/vcs/log/CommitId;", "", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation;", "requestData", "", "commits", "getLoaders", "dispose", "ProviderLoader", "intellij.platform.vcs.log.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsLogCommitSelectionListenerForDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogCommitSelectionListenerForDetails.kt\ncom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,302:1\n1869#2,2:303\n1869#2,2:305\n11561#3:307\n11896#3,3:308\n1#4:311\n382#5,7:312\n*S KotlinDebug\n*F\n+ 1 VcsLogCommitSelectionListenerForDetails.kt\ncom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader\n*L\n235#1:303,2\n241#1:305,2\n266#1:307\n266#1:308,3\n245#1:312,7\n*E\n"})
    private static final class ExternalStatusesAsyncLoader
    implements Disposable {
        @NotNull
        private final Project project;
        @NotNull
        private final CommitDetailsListPanel detailsPanel;
        @Nullable
        private Disposable loadersDisposable;
        @Nullable
        private List<? extends ProviderLoader<?>> loaders;
        @NotNull
        private Map<CommitId, Map<String, VcsCommitExternalStatusPresentation>> statuses;

        public ExternalStatusesAsyncLoader(@NotNull Project project, @NotNull CommitDetailsListPanel detailsPanel) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)detailsPanel), (String)"detailsPanel");
            this.project = project;
            this.detailsPanel = detailsPanel;
            this.statuses = new LinkedHashMap();
            VcsCommitExternalStatusProvider.Companion.addProviderListChangeListener(this, (Function0<Unit>)((Function0)() -> ExternalStatusesAsyncLoader._init_$lambda$0(this)));
        }

        public final void requestData(@NotNull List<CommitId> commits) {
            Intrinsics.checkNotNullParameter(commits, (String)"commits");
            this.statuses = new LinkedHashMap();
            if (commits.isEmpty()) {
                List<? extends ProviderLoader<?>> list = this.loaders;
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ProviderLoader it = (ProviderLoader)element$iv;
                        boolean bl = false;
                        it.requestData(CollectionsKt.emptyList(), (Function1<Map<CommitId, VcsCommitExternalStatusPresentation>, Unit>)((Function1)ExternalStatusesAsyncLoader::requestData$lambda$0$0));
                    }
                }
                return;
            }
            Iterable $this$forEach$iv = this.getLoaders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProviderLoader loader = (ProviderLoader)element$iv;
                boolean bl = false;
                loader.requestData(commits, (Function1<Map<CommitId, VcsCommitExternalStatusPresentation>, Unit>)((Function1)arg_0 -> ExternalStatusesAsyncLoader.requestData$lambda$1$0(this, loader, arg_0)));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<ProviderLoader<?>> getLoaders() {
            if (this.loaders == null && !Disposer.isDisposed((Disposable)this)) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Disposable disposable2 = Disposer.newDisposable((Disposable)this, (String)"Status loaders");
                Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
                Disposable disposable3 = disposable2;
                Object[] objectArray = VcsCommitExternalStatusProvider.Companion.getEP$intellij_platform_vcs_log_impl().getExtensions();
                ExternalStatusesAsyncLoader externalStatusesAsyncLoader = this;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void provider;
                    ProviderLoader providerLoader;
                    VcsCommitExternalStatusProvider vcsCommitExternalStatusProvider = (VcsCommitExternalStatusProvider)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ProviderLoader it = providerLoader = new ProviderLoader(this.project, provider);
                    boolean bl2 = false;
                    Disposer.register((Disposable)disposable3, (Disposable)it);
                    collection.add(providerLoader);
                }
                externalStatusesAsyncLoader.loaders = (List)destination$iv$iv;
                this.loadersDisposable = disposable3;
            }
            List<ProviderLoader<?>> list = this.loaders;
            Intrinsics.checkNotNull(list);
            return list;
        }

        public void dispose() {
        }

        private static final Unit _init_$lambda$0(ExternalStatusesAsyncLoader this$0) {
            Disposable disposable2 = this$0.loadersDisposable;
            if (disposable2 != null) {
                Disposable it = disposable2;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this$0.loaders = null;
            this$0.requestData(CollectionsKt.toList((Iterable)this$0.statuses.keySet()));
            return Unit.INSTANCE;
        }

        private static final Unit requestData$lambda$0$0(Map it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit requestData$lambda$1$0(ExternalStatusesAsyncLoader this$0, ProviderLoader $loader, Map result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            for (Map.Entry entry : result.entrySet()) {
                Object object;
                void $this$getOrPut$iv;
                CommitId commit = (CommitId)entry.getKey();
                VcsCommitExternalStatusPresentation statusPresentation = (VcsCommitExternalStatusPresentation)entry.getValue();
                Map<CommitId, Map<String, VcsCommitExternalStatusPresentation>> map = this$0.statuses;
                CommitId key$iv = commit;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Map answer$iv = new LinkedHashMap();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                Map presentations = (Map)object;
                if (statusPresentation == null) {
                    presentations.remove($loader.getId());
                    continue;
                }
                presentations.put($loader.getId(), statusPresentation);
            }
            this$0.detailsPanel.forEachPanel((Function2<? super CommitId, ? super CommitDetailsPanel, Unit>)((Function2)(arg_0, arg_1) -> ExternalStatusesAsyncLoader.requestData$lambda$1$0$1(this$0, arg_0, arg_1)));
            return Unit.INSTANCE;
        }

        private static final Unit requestData$lambda$1$0$1(ExternalStatusesAsyncLoader this$0, CommitId commit, CommitDetailsPanel panel) {
            List list;
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Map<String, VcsCommitExternalStatusPresentation> map = this$0.statuses.get(commit);
            if ((map != null && (map = map.values()) != null ? CollectionsKt.toList((Iterable)((Iterable)((Object)map))) : (list = null)) == null) {
                list = CollectionsKt.emptyList();
            }
            panel.setStatuses(list);
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ6\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132 \u0010\u0015\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017\u0012\u0004\u0012\u00020\u00110\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader$ProviderLoader;", "T", "Lcom/intellij/vcs/log/data/VcsCommitExternalStatus;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "provider", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusProvider;)V", "id", "", "getId", "()Ljava/lang/String;", "loader", "Lcom/intellij/vcs/log/data/util/VcsCommitsDataLoader;", "requestData", "", "commits", "", "Lcom/intellij/vcs/log/CommitId;", "onChange", "Lkotlin/Function1;", "", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation;", "dispose", "intellij.platform.vcs.log.impl"})
        @SourceDebugExtension(value={"SMAP\nVcsLogCommitSelectionListenerForDetails.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogCommitSelectionListenerForDetails.kt\ncom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader$ProviderLoader\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n463#2:303\n413#2:304\n1252#3,4:305\n*S KotlinDebug\n*F\n+ 1 VcsLogCommitSelectionListenerForDetails.kt\ncom/intellij/vcs/log/ui/frame/VcsLogCommitSelectionListenerForDetails$ExternalStatusesAsyncLoader$ProviderLoader\n*L\n290#1:303\n290#1:304\n290#1:305,4\n*E\n"})
        private static final class ProviderLoader<T extends VcsCommitExternalStatus>
        implements Disposable {
            @NotNull
            private final Project project;
            @NotNull
            private final VcsCommitExternalStatusProvider<T> provider;
            @NotNull
            private final String id;
            @NotNull
            private final VcsCommitsDataLoader<T> loader;

            /*
             * WARNING - void declaration
             */
            public ProviderLoader(@NotNull Project project, @NotNull VcsCommitExternalStatusProvider<T> provider) {
                void it;
                VcsCommitsDataLoader<T> vcsCommitsDataLoader;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(provider, (String)"provider");
                this.project = project;
                this.provider = provider;
                this.id = this.provider.getId();
                VcsCommitsDataLoader<T> vcsCommitsDataLoader2 = vcsCommitsDataLoader = this.provider.createLoader(this.project);
                ProviderLoader providerLoader = this;
                boolean bl = false;
                Disposer.register((Disposable)this, (Disposable)((Disposable)it));
                providerLoader.loader = vcsCommitsDataLoader;
            }

            @NotNull
            public final String getId() {
                return this.id;
            }

            public final void requestData(@NotNull List<CommitId> commits, @NotNull Function1<? super Map<CommitId, ? extends VcsCommitExternalStatusPresentation>, Unit> onChange) {
                Intrinsics.checkNotNullParameter(commits, (String)"commits");
                Intrinsics.checkNotNullParameter(onChange, (String)"onChange");
                this.loader.loadData(commits, arg_0 -> ProviderLoader.requestData$lambda$0(onChange, this, arg_0));
            }

            public void dispose() {
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit requestData$lambda$0(Function1 $onChange, ProviderLoader this$0, Map it) {
                void $this$associateByTo$iv$iv$iv;
                void $this$mapValuesTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Map $this$mapValues$iv = it;
                boolean $i$f$mapValues = false;
                Map map = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
                Map destination$iv$iv$iv = destination$iv$iv;
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map3 = map2;
                    boolean bl2 = false;
                    VcsCommitExternalStatus status = (VcsCommitExternalStatus)entry2.getValue();
                    VcsCommitExternalStatusPresentation vcsCommitExternalStatusPresentation = this$0.provider.getPresentation(this$0.project, status);
                    map3.put(k, vcsCommitExternalStatusPresentation);
                }
                Map presentations = destination$iv$iv$iv;
                $onChange.invoke((Object)presentations);
                return Unit.INSTANCE;
            }
        }
    }
}

