/*
 * Decompiled with CFR 0.152.
 */
package runtime.x;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.collections.Stack;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.MutableProperty;
import runtime.text.TextRange;
import runtime.x.SelectionVM;
import runtime.x.XTextHistory;
import runtime.x.XTextHistoryContinuationStrategy;
import runtime.x.XTextHistoryStrategy;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J&\u0010\u001a\u001a\u00020\u0018*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00110\u00102\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u001e\u0010\u001c\u001a\u00020\u0018*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00110\u0010H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lruntime/x/TextChangeHistory;", "Lruntime/x/XTextHistory;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "textState", "Lruntime/reactive/MutableProperty;", "", "selectionVM", "Lruntime/x/SelectionVM;", "strategy", "Lruntime/x/XTextHistoryStrategy;", "<init>", "(Llibraries/coroutines/extra/Lifetime;Lruntime/reactive/MutableProperty;Lruntime/x/SelectionVM;Lruntime/x/XTextHistoryStrategy;)V", "getStrategy", "()Lruntime/x/XTextHistoryStrategy;", "undoStack", "Llibraries/collections/Stack;", "Lkotlin/Pair;", "Lruntime/text/TextRange;", "redoStack", "lastHandledText", "inputJustHappened", "", "redo", "", "undo", "pushState", "text", "popState", "platform-ui"})
public final class TextChangeHistory
implements XTextHistory {
    @NotNull
    private final MutableProperty<String> textState;
    @NotNull
    private final SelectionVM selectionVM;
    @NotNull
    private final XTextHistoryStrategy strategy;
    @NotNull
    private Stack<Pair<String, TextRange>> undoStack;
    @NotNull
    private Stack<Pair<String, TextRange>> redoStack;
    @Nullable
    private String lastHandledText;
    private boolean inputJustHappened;

    public TextChangeHistory(@NotNull Lifetime lifetime, @NotNull MutableProperty<String> textState, @NotNull SelectionVM selectionVM, @NotNull XTextHistoryStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(textState, (String)"textState");
        Intrinsics.checkNotNullParameter((Object)selectionVM, (String)"selectionVM");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        this.textState = textState;
        this.selectionVM = selectionVM;
        this.strategy = strategy;
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.textState.forEachWithPrevious(lifetime, (Function2<String, String, Unit>)((Function2)(arg_0, arg_1) -> TextChangeHistory._init_$lambda$0(this, arg_0, arg_1)));
        this.selectionVM.getSelection().forEach(lifetime, arg_0 -> TextChangeHistory._init_$lambda$1(this, arg_0));
    }

    public /* synthetic */ TextChangeHistory(Lifetime lifetime, MutableProperty mutableProperty, SelectionVM selectionVM, XTextHistoryStrategy xTextHistoryStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            xTextHistoryStrategy = new XTextHistoryContinuationStrategy();
        }
        this(lifetime, mutableProperty, selectionVM, xTextHistoryStrategy);
    }

    @NotNull
    public final XTextHistoryStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void redo() {
        if (this.redoStack.getSize() != 0) {
            this.pushState(this.undoStack, this.textState.getValue());
            this.popState(this.redoStack);
        }
    }

    @Override
    public void undo() {
        if (this.undoStack.getSize() > 0) {
            this.pushState(this.redoStack, this.textState.getValue());
            this.popState(this.undoStack);
        }
    }

    private final void pushState(Stack<Pair<String, TextRange>> $this$pushState, String text2) {
        $this$pushState.push((Pair<String, TextRange>)TuplesKt.to((Object)text2, this.selectionVM.getSelection().getValue()));
    }

    private final void popState(Stack<Pair<String, TextRange>> $this$popState) {
        Pair<String, TextRange> pair = $this$popState.pop();
        String prevText = (String)pair.component1();
        TextRange sel = (TextRange)pair.component2();
        this.lastHandledText = prevText;
        this.textState.setValue(prevText);
        this.selectionVM.setSelection(sel);
        this.strategy.breakContinuation();
    }

    private static final Unit _init_$lambda$0(TextChangeHistory this$0, String prev, String curr) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
        this$0.inputJustHappened = true;
        if (prev == null || Intrinsics.areEqual((Object)curr, (Object)this$0.lastHandledText)) {
            return Unit.INSTANCE;
        }
        this$0.redoStack.clear();
        int selectionLength = ((TextRange)this$0.selectionVM.getSelection().getValue()).getLength();
        boolean shouldCreateNewBatch = this$0.strategy.shouldStartNewBatch(prev.length() - selectionLength, curr.length());
        if (shouldCreateNewBatch) {
            this$0.pushState(this$0.undoStack, prev);
        }
        this$0.lastHandledText = curr;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(TextChangeHistory this$0, TextRange it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.inputJustHappened || it.getLength() != 0) {
            this$0.strategy.breakContinuation();
        }
        this$0.inputJustHappened = false;
        return Unit.INSTANCE;
    }
}

