/*
 * Decompiled with CFR 0.152.
 */
package runtime.serialization;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import libraries.collections.MultiMap;
import libraries.collections.MultiMapKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.container.DescriptorsKt;
import runtime.serialization.PlatformIndependentHashKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0007J\u001c\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u000e2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0012\u0010\u0011\u001a\u00020\u00062\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0012\u0010\u0013\u001a\u00020\u00062\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0007J \u0010\u0014\u001a\n\u0012\u0004\u0012\u0002H\u0015\u0018\u00010\u0007\"\b\b\u0000\u0010\u0015*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0006R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lruntime/serialization/TypeRegistry;", "", "<init>", "()V", "registry", "", "", "Lkotlin/reflect/KClass;", "registryByClass", "inheritors", "Llibraries/collections/MultiMap;", "register", "", "kClass", "", "isRegistered", "", "hierarchyHash", "kclass", "typeHash", "kClassOrNull", "T", "Companion", "platform-runtime"})
@SourceDebugExtension(value={"SMAP\nTypeRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeRegistry.kt\nruntime/serialization/TypeRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1863#2,2:67\n1797#2,3:69\n*S KotlinDebug\n*F\n+ 1 TypeRegistry.kt\nruntime/serialization/TypeRegistry\n*L\n31#1:67,2\n53#1:69,3\n*E\n"})
public final class TypeRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Long, KClass<?>> registry = new LinkedHashMap();
    @NotNull
    private final Map<KClass<?>, Long> registryByClass = new LinkedHashMap();
    @NotNull
    private final MultiMap<KClass<?>, KClass<?>> inheritors = MultiMapKt.linkedMultiMap$default(null, 1, null);

    public final void register(@NotNull KClass<?> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        long hash = Companion.calculateHash(kClass);
        KClass<?> otherKClass = this.registry.get(hash);
        if (otherKClass != null) {
            if (Intrinsics.areEqual((Object)kClass.getQualifiedName(), (Object)otherKClass.getQualifiedName())) {
                throw new IllegalStateException(("Can not register type " + kClass.getQualifiedName() + " because it is already registered using another classloader " + JvmClassMappingKt.getJavaClass(otherKClass).getClassLoader() + " (current classloader is " + JvmClassMappingKt.getJavaClass(kClass).getClassLoader() + ")").toString());
            }
            String string = kClass.getQualifiedName();
            KClass<?> kClass2 = this.registry.get(hash);
            Intrinsics.checkNotNull(kClass2);
            throw new IllegalStateException(("Can not register type " + string + " because type " + kClass2.getQualifiedName() + " with the same hash has already been registered").toString());
        }
        Long l = hash;
        this.registry.put(l, kClass);
        l = hash;
        this.registryByClass.put(kClass, l);
        Iterable $this$forEach$iv = DescriptorsKt.supertypes(JvmClassMappingKt.getJavaClass(kClass));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Type it = (Type)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.lang.Class<*>");
            this.inheritors.put(JvmClassMappingKt.getKotlinClass((Class)((Class)it)), kClass);
        }
    }

    @NotNull
    public final Collection<KClass<?>> inheritors(@NotNull KClass<?> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        return this.inheritors.get(kClass);
    }

    public final boolean isRegistered(@NotNull KClass<?> kClass) {
        Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
        long hash = Companion.calculateHash(kClass);
        boolean containsHash = this.registry.containsKey(hash);
        boolean containsClass = this.registryByClass.containsKey(kClass);
        if (containsHash != containsClass) {
            throw new IllegalStateException(("Inconsistent state of type registry: hash " + hash + " is registered for " + this.registry.get(hash) + ", but another " + kClass + " has the same hash. This is possible if two different classes has same simple name, or can be a class loading issue.").toString());
        }
        return containsHash;
    }

    /*
     * WARNING - void declaration
     */
    public final long hierarchyHash(@NotNull KClass<?> kclass) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        Iterable iterable = this.inheritors.get(kclass);
        long initial$iv = 0L;
        boolean $i$f$fold = false;
        long accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void it;
            KClass kClass = (KClass)element$iv;
            long acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc * (long)31 + Companion.calculateHash((KClass<?>)it);
        }
        return accumulator$iv;
    }

    public final long typeHash(@NotNull KClass<?> kclass) {
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        Long l = this.registryByClass.get(kclass);
        if (l == null) {
            throw new IllegalStateException(("Type " + kclass.getQualifiedName() + " is not registered").toString());
        }
        return l;
    }

    @Nullable
    public final <T> KClass<T> kClassOrNull(long typeHash) {
        return this.registry.get(typeHash);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a8\u0006\b"}, d2={"Lruntime/serialization/TypeRegistry$Companion;", "", "<init>", "()V", "calculateHash", "", "kClass", "Lkotlin/reflect/KClass;", "platform-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public final long calculateHash(@NotNull KClass<?> kClass) {
            Intrinsics.checkNotNullParameter(kClass, (String)"kClass");
            return PlatformIndependentHashKt.platformIndependentHash$default(kClass.getSimpleName(), 0L, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

