/*
 * Decompiled with CFR 0.152.
 */
package runtime.date;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.date.FormattersKt;
import runtime.date.TimeInterval;
import runtime.date.TimeOfDay;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0006\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"validate", "", "Lruntime/date/TimeOfDay;", "toSeconds", "", "format", "Lruntime/date/TimeInterval;", "hoursPadded", "", "pad2", "platform-runtime"})
public final class TimeOfDayKt {
    @Nullable
    public static final String validate(@NotNull TimeOfDay $this$validate) {
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        if ($this$validate.getHours() < 0 || $this$validate.getHours() > 24) {
            return "invalid hour " + $this$validate.getHours();
        }
        if ($this$validate.getMinutes() < 0 || $this$validate.getMinutes() > 60) {
            return "invalid minute " + $this$validate.getMinutes();
        }
        if ($this$validate.getHours() == 24 && $this$validate.getMinutes() != 0) {
            return "invalid time";
        }
        return null;
    }

    public static final int toSeconds(@NotNull TimeOfDay $this$toSeconds) {
        Intrinsics.checkNotNullParameter((Object)$this$toSeconds, (String)"<this>");
        Integer n = $this$toSeconds.getSeconds();
        return $this$toSeconds.getHours() * 60 * 60 + $this$toSeconds.getMinutes() * 60 + (n != null ? n : 0);
    }

    @NotNull
    public static final String format(@NotNull TimeInterval $this$format) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        return FormattersKt.timeRangeText(TimeOfDayKt.format$default($this$format.getSince(), false, 1, null), TimeOfDayKt.format$default($this$format.getTill(), false, 1, null));
    }

    @NotNull
    public static final String format(@NotNull TimeOfDay $this$format, boolean hoursPadded) {
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        return (hoursPadded ? TimeOfDayKt.pad2($this$format.getHours()) : String.valueOf($this$format.getHours())) + ":" + TimeOfDayKt.pad2($this$format.getMinutes());
    }

    public static /* synthetic */ String format$default(TimeOfDay timeOfDay, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return TimeOfDayKt.format(timeOfDay, bl);
    }

    private static final String pad2(int $this$pad2) {
        return StringsKt.padStart((String)String.valueOf($this$pad2), (int)2, (char)'0');
    }
}

