/*
 * Decompiled with CFR 0.152.
 */
package libraries.io.blobs;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URLConnection;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import libraries.io.blobs.RequestContent;
import libraries.io.channels.FileChannelsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Llibraries/io/blobs/FileRequestContent;", "Llibraries/io/blobs/RequestContent;", "filePath", "Ljava/nio/file/Path;", "contentType", "", "metadata", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/util/Map;)V", "getFilePath", "()Ljava/nio/file/Path;", "getMetadata", "()Ljava/util/Map;", "contentLength", "", "getContentLength", "()J", "contentRange", "Lkotlin/ranges/LongRange;", "getContentRange", "()Lkotlin/ranges/LongRange;", "getContentType", "()Ljava/lang/String;", "contentType$delegate", "Lkotlin/Lazy;", "getContent", "Ljava/nio/channels/ReadableByteChannel;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "libraries-io"})
public final class FileRequestContent
implements RequestContent {
    @NotNull
    private final Path filePath;
    @NotNull
    private final Map<String, String> metadata;
    private final long contentLength;
    @NotNull
    private final LongRange contentRange;
    @NotNull
    private final Lazy contentType$delegate;

    public FileRequestContent(@NotNull Path filePath, @Nullable String contentType, @NotNull Map<String, String> metadata) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        this.filePath = filePath;
        this.metadata = metadata;
        this.contentLength = Files.size(this.filePath);
        this.contentRange = new LongRange(0L, this.getContentLength());
        this.contentType$delegate = LazyKt.lazy(() -> FileRequestContent.contentType_delegate$lambda$1(contentType, this));
    }

    public /* synthetic */ FileRequestContent(Path path, String string, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(path, string, map2);
    }

    @NotNull
    public final Path getFilePath() {
        return this.filePath;
    }

    @Override
    @NotNull
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    @NotNull
    public LongRange getContentRange() {
        return this.contentRange;
    }

    @Override
    @Nullable
    public String getContentType() {
        Lazy lazy = this.contentType$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public Object getContent(@NotNull Continuation<? super ReadableByteChannel> $completion) {
        return FileChannelsKt.readableChannel$default(this.filePath, 0L, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String contentType_delegate$lambda$1(String $contentType, FileRequestContent this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = $contentType;
        if (string == null) {
            String string2;
            Closeable closeable = Files.newInputStream(this$0.filePath, new OpenOption[0]);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                String string3 = URLConnection.guessContentTypeFromStream(it);
                string2 = string3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            string = string2;
            if (string2 == null) {
                string = "application/octet-stream";
            }
        }
        return string;
    }
}

