/*
 * Decompiled with CFR 0.152.
 */
package libraries.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import libraries.collections.LongHashMap;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u001aS\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052-\u0010\u0006\u001a)\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0007H\u0086\b\u00f8\u0001\u0000\u001a1\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0003\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u000e\u001a1\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0003\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0010\u001a\u0002H\u00022\u0006\u0010\u0011\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0012\u001a$\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0003\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005\u001a.\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0015\"\u0006\b\u0000\u0010\u0002\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u0002H\u0087\b\u00a2\u0006\u0002\u0010\u0017\u001a^\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\u0019\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u001a\"\u0004\b\u0002\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u00020\u001c2\u0014\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u001a0\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u001b0\u001eH\u0086\b\u00f8\u0001\u0000\u001aH\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u0002H\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u00030!0\u0003\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u001a*\b\u0012\u0004\u0012\u0002H\u00020\u001c2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u001a0\u001e\u001aH\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u0002H\u001b0\u0019\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010\u001b*\b\u0012\u0004\u0012\u0002H%0&2\u001e\u0010'\u001a\u001a\u0012\u0004\u0012\u0002H%\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u0002H\u001b0!0\u001e\u001aV\u0010(\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0\u00030\u0019\"\u0004\b\u0000\u0010%\"\u0004\b\u0001\u0010\u001b*\b\u0012\u0004\u0012\u0002H%0&2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u00020$0\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H%\u0012\u0004\u0012\u0002H\u001b0\u001e\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006)"}, d2={"forEachGrouped", "", "T", "", "count", "", "handler", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "iteration", "replaceAt", "index", "v", "(Ljava/util/List;ILjava/lang/Object;)Ljava/util/List;", "replace", "old", "new", "(Ljava/util/List;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;", "deleteAt", "remove", "", "elt", "([Ljava/lang/Object;Ljava/lang/Object;)[Ljava/lang/Object;", "associateByNullable", "", "K", "V", "", "keySelector", "Lkotlin/Function1;", "valueTransform", "groupConsecutiveBy", "Lkotlin/Pair;", "keyFunction", "associateToLongMap", "", "S", "", "transform", "groupByToLongMap", "libraries-collections"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\nlibraries/collections/ExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,88:1\n1557#2:89\n1628#2,3:90\n827#2:93\n855#2,2:94\n1187#2,2:96\n1261#2,4:98\n1797#2,3:102\n1261#2,4:105\n1528#2,3:110\n1531#2,3:120\n1#3:109\n381#4,7:113\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\nlibraries/collections/ExtensionsKt\n*L\n50#1:89\n50#1:90,3\n51#1:93\n51#1:94,2\n52#1:96,2\n52#1:98,4\n62#1:102,3\n73#1:105,4\n84#1:110,3\n84#1:120,3\n84#1:113,7\n*E\n"})
public final class ExtensionsKt {
    public static final <T> void forEachGrouped(@NotNull List<? extends T> $this$forEachGrouped, int count, @NotNull Function2<? super Integer, ? super List<? extends T>, Unit> handler) {
        List<T> l;
        Intrinsics.checkNotNullParameter($this$forEachGrouped, (String)"<this>");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        boolean $i$f$forEachGrouped = false;
        int iteration = 0;
        for (int offset = 0; offset < $this$forEachGrouped.size(); offset += l.size()) {
            l = $this$forEachGrouped.subList(offset, Math.min(offset + count, $this$forEachGrouped.size()));
            handler.invoke((Object)iteration, l);
            ++iteration;
        }
    }

    @NotNull
    public static final <T> List<T> replaceAt(@NotNull List<? extends T> $this$replaceAt, int index, T v) {
        Intrinsics.checkNotNullParameter($this$replaceAt, (String)"<this>");
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)$this$replaceAt.subList(0, index), v), (Iterable)$this$replaceAt.subList(index + 1, $this$replaceAt.size()));
    }

    @NotNull
    public static final <T> List<T> replace(@NotNull List<? extends T> $this$replace, T old, T t) {
        Intrinsics.checkNotNullParameter($this$replace, (String)"<this>");
        int index = $this$replace.indexOf(old);
        if (index < 0) {
            return $this$replace;
        }
        return ExtensionsKt.replaceAt($this$replace, index, t);
    }

    @NotNull
    public static final <T> List<T> deleteAt(@NotNull List<? extends T> $this$deleteAt, int index) {
        Intrinsics.checkNotNullParameter($this$deleteAt, (String)"<this>");
        return CollectionsKt.plus((Collection)$this$deleteAt.subList(0, index), (Iterable)$this$deleteAt.subList(index + 1, $this$deleteAt.size()));
    }

    @Deprecated(message="Please use collections instead. There is no point in using a low-level type such as Array")
    public static final /* synthetic */ <T> T[] remove(T[] $this$remove, T elt) {
        Intrinsics.checkNotNullParameter($this$remove, (String)"<this>");
        boolean $i$f$remove = false;
        int idx = ArraysKt.indexOf((Object[])$this$remove, elt);
        if (idx == -1) {
            return $this$remove;
        }
        int n = $this$remove.length - 1;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T");
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            objectArray[n2] = n2 < idx ? $this$remove[n2] : $this$remove[n2 + 1];
        }
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, K, V> Map<K, V> associateByNullable(@NotNull Iterable<? extends T> $this$associateByNullable, @NotNull Function1<? super T, ? extends K> keySelector, @NotNull Function1<? super T, ? extends V> valueTransform) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Pair it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$associateByNullable, (String)"<this>");
        Intrinsics.checkNotNullParameter(keySelector, (String)"keySelector");
        Intrinsics.checkNotNullParameter(valueTransform, (String)"valueTransform");
        boolean $i$f$associateByNullable = false;
        Iterable $this$map$iv = $this$associateByNullable;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)keySelector.invoke((Object)it), (Object)valueTransform.invoke((Object)it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (it.getFirst() == null) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            Pair it2 = (Pair)element$iv$iv;
            boolean bl = false;
            Object object = it2.getFirst();
            Intrinsics.checkNotNull((Object)object);
            Pair pair = TuplesKt.to((Object)object, (Object)it2.getSecond());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, K> List<Pair<K, List<T>>> groupConsecutiveBy(@NotNull Iterable<? extends T> $this$groupConsecutiveBy, @NotNull Function1<? super T, ? extends K> keyFunction) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter($this$groupConsecutiveBy, (String)"<this>");
        Intrinsics.checkNotNullParameter(keyFunction, (String)"keyFunction");
        Iterable<? extends T> iterable = $this$groupConsecutiveBy;
        List initial$iv = new ArrayList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void v;
            Object element$iv;
            Object t = element$iv = iterator2.next();
            List acc = accumulator$iv;
            boolean bl = false;
            Object k = keyFunction.invoke((Object)v);
            if (acc.isEmpty() || !Intrinsics.areEqual((Object)((Pair)CollectionsKt.last((List)acc)).getFirst(), (Object)k)) {
                Collection collection = acc;
                Object[] objectArray = new Object[]{v};
                collection.add(TuplesKt.to((Object)k, (Object)CollectionsKt.mutableListOf((Object[])objectArray)));
            } else {
                ((Collection)((Pair)CollectionsKt.last((List)acc)).getSecond()).add(v);
            }
            accumulator$iv = acc;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <S, V> Map<Long, V> associateToLongMap(@NotNull Collection<? extends S> $this$associateToLongMap, @NotNull Function1<? super S, ? extends Pair<Long, ? extends V>> transform2) {
        Map map2;
        Intrinsics.checkNotNullParameter($this$associateToLongMap, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        int size = $this$associateToLongMap.size();
        switch (size) {
            case 0: {
                map2 = MapsKt.emptyMap();
                break;
            }
            case 1: {
                map2 = MapsKt.mapOf((Pair)((Pair)transform2.invoke(CollectionsKt.first((Iterable)$this$associateToLongMap))));
                break;
            }
            default: {
                void $this$associateTo$iv;
                Iterable iterable = $this$associateToLongMap;
                Map destination$iv = (Map)((Object)new LongHashMap(size, 0.0f, 2, null));
                boolean $i$f$associateTo = false;
                for (Object element$iv : $this$associateTo$iv) {
                    Map map3 = destination$iv;
                    Pair pair = (Pair)transform2.invoke(element$iv);
                    map3.put(pair.getFirst(), pair.getSecond());
                }
                map2 = destination$iv;
            }
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <S, V> Map<Long, List<V>> groupByToLongMap(@NotNull Collection<? extends S> $this$groupByToLongMap, @NotNull Function1<? super S, Long> keySelector, @NotNull Function1<? super S, ? extends V> valueTransform) {
        Map map2;
        Intrinsics.checkNotNullParameter($this$groupByToLongMap, (String)"<this>");
        Intrinsics.checkNotNullParameter(keySelector, (String)"keySelector");
        Intrinsics.checkNotNullParameter(valueTransform, (String)"valueTransform");
        int size = $this$groupByToLongMap.size();
        switch (size) {
            case 0: {
                map2 = MapsKt.emptyMap();
                break;
            }
            case 1: {
                Object it = CollectionsKt.first((Iterable)$this$groupByToLongMap);
                boolean bl = false;
                map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)keySelector.invoke(it), (Object)CollectionsKt.listOf((Object)valueTransform.invoke(it))));
                break;
            }
            default: {
                void $this$groupByTo$iv;
                Iterable iterable = $this$groupByToLongMap;
                Map destination$iv = (Map)((Object)new LongHashMap(size, 0.0f, 2, null));
                boolean $i$f$groupByTo = false;
                for (Object element$iv : $this$groupByTo$iv) {
                    Object object;
                    Object key$iv = keySelector.invoke(element$iv);
                    Map $this$getOrPut$iv$iv = destination$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                    if (value$iv$iv == null) {
                        boolean bl = false;
                        List answer$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                        object = answer$iv$iv;
                    } else {
                        object = value$iv$iv;
                    }
                    List list$iv = (List)object;
                    list$iv.add(valueTransform.invoke(element$iv));
                }
                map2 = destination$iv;
            }
        }
        return map2;
    }
}

