/*
 * Decompiled with CFR 0.152.
 */
package libraries.basics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import libraries.basics.BracketPair;
import libraries.basics.BracketTreeNode;
import libraries.basics.BracketTreeRoot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Llibraries/basics/BracketsParser;", "", "bracketPairs", "", "Llibraries/basics/BracketPair;", "<init>", "(Ljava/util/List;)V", "", "([Llibraries/basics/BracketPair;)V", "parse", "Llibraries/basics/BracketTreeRoot;", "text", "", "BracketTreeNodeBuilder", "libraries-basics"})
@SourceDebugExtension(value={"SMAP\nBracketsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracketsParser.kt\nlibraries/basics/BracketsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1863#2,2:76\n*S KotlinDebug\n*F\n+ 1 BracketsParser.kt\nlibraries/basics/BracketsParser\n*L\n43#1:76,2\n*E\n"})
public final class BracketsParser {
    @NotNull
    private final List<BracketPair> bracketPairs;

    public BracketsParser(@NotNull List<BracketPair> bracketPairs) {
        Intrinsics.checkNotNullParameter(bracketPairs, (String)"bracketPairs");
        this.bracketPairs = bracketPairs;
    }

    public BracketsParser(BracketPair ... bracketPairs) {
        Intrinsics.checkNotNullParameter((Object)bracketPairs, (String)"bracketPairs");
        this(ArraysKt.asList((Object[])bracketPairs));
    }

    @NotNull
    public final BracketTreeRoot parse(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List rootChildren = new ArrayList();
        List stack = new ArrayList();
        int i = 0;
        while (i < text2.length()) {
            boolean bl;
            BracketTreeNodeBuilder currentNode = (BracketTreeNodeBuilder)CollectionsKt.lastOrNull((List)stack);
            char c = text2.charAt(i);
            Object object = currentNode;
            if (object != null && (object = ((BracketTreeNodeBuilder)object).getBrackets()) != null) {
                Character c2 = ((BracketPair)object).getEscaping();
                char c3 = c;
                bl = c2 != null && c2.charValue() == c3;
            } else {
                bl = false;
            }
            if (bl) {
                i += 2;
                continue;
            }
            Object object2 = currentNode;
            boolean bl2 = object2 != null && (object2 = ((BracketTreeNodeBuilder)object2).getBrackets()) != null ? ((BracketPair)object2).getClosing() == c : false;
            if (bl2) {
                CollectionsKt.removeLast((List)stack);
                Object object3 = (BracketTreeNodeBuilder)CollectionsKt.lastOrNull((List)stack);
                if (object3 == null || (object3 = ((BracketTreeNodeBuilder)object3).getChildren()) == null) {
                    object3 = rootChildren;
                }
                Collection collection = (Collection)object3;
                collection.add(currentNode.build(i));
            } else if (currentNode == null || !currentNode.getBrackets().getIgnoreContent()) {
                Iterable $this$forEach$iv = this.bracketPairs;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BracketPair it = (BracketPair)element$iv;
                    boolean bl3 = false;
                    if (it.getOpening() == c) {
                        ((Collection)stack).add(new BracketTreeNodeBuilder(i, it, new ArrayList()));
                        continue;
                    }
                    if (it.getClosing() != c) continue;
                    throw new IllegalStateException(("Invalid brackets sequence (unexpected closing bracket; index " + i + "): " + text2).toString());
                }
            }
            int n = i;
            i = n + 1;
        }
        if (CollectionsKt.any((Iterable)stack)) {
            throw new IllegalStateException(("Invalid brackets sequence (unmatched opening bracket; index " + ((BracketTreeNodeBuilder)CollectionsKt.last((List)stack)).getStart() + "): " + text2).toString());
        }
        return new BracketTreeRoot(rootChildren);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Llibraries/basics/BracketsParser$BracketTreeNodeBuilder;", "", "start", "", "brackets", "Llibraries/basics/BracketPair;", "children", "", "Llibraries/basics/BracketTreeNode;", "<init>", "(ILlibraries/basics/BracketPair;Ljava/util/List;)V", "getStart", "()I", "getBrackets", "()Llibraries/basics/BracketPair;", "getChildren", "()Ljava/util/List;", "build", "end", "libraries-basics"})
    private static final class BracketTreeNodeBuilder {
        private final int start;
        @NotNull
        private final BracketPair brackets;
        @NotNull
        private final List<BracketTreeNode> children;

        public BracketTreeNodeBuilder(int start2, @NotNull BracketPair brackets, @NotNull List<BracketTreeNode> children) {
            Intrinsics.checkNotNullParameter((Object)brackets, (String)"brackets");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.start = start2;
            this.brackets = brackets;
            this.children = children;
        }

        public final int getStart() {
            return this.start;
        }

        @NotNull
        public final BracketPair getBrackets() {
            return this.brackets;
        }

        @NotNull
        public final List<BracketTreeNode> getChildren() {
            return this.children;
        }

        @NotNull
        public final BracketTreeNode build(int end) {
            return new BracketTreeNode(this.start, end, this.brackets, this.children);
        }
    }
}

