/*
 * Decompiled with CFR 0.152.
 */
package circlet.todo;

import circlet.client.api.TodoAnchor;
import circlet.client.api.TodoContent;
import circlet.client.api.TodoItemContent;
import circlet.client.api.TodoItemRecord;
import circlet.platform.api.Ref;
import circlet.platform.client.RefResolveKt;
import circlet.todo.TodoItemCategory;
import circlet.todo.TodoItemCategoryKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010%\u001a\u00020\u001bH\u0016R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u001f\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b \u0010\u0019\u00a8\u0006&"}, d2={"Lcirclet/todo/TodoListItemVm;", "", "ref", "Lcirclet/platform/api/Ref;", "Lcirclet/client/api/TodoItemRecord;", "optimistic", "<init>", "(Lcirclet/platform/api/Ref;Lcirclet/client/api/TodoItemRecord;)V", "getRef", "()Lcirclet/platform/api/Ref;", "getOptimistic", "()Lcirclet/client/api/TodoItemRecord;", "record", "getRecord", "anchor", "Lcirclet/client/api/TodoAnchor;", "getAnchor", "()Lcirclet/client/api/TodoAnchor;", "category", "Lcirclet/todo/TodoItemCategory;", "getCategory", "()Lcirclet/todo/TodoItemCategory;", "link", "", "getLink", "()Ljava/lang/String;", "sortingKey", "", "getSortingKey", "()I", "extId", "Lcirclet/platform/api/TID;", "getExtId", "Ljava/lang/String;", "equals", "", "other", "hashCode", "spaceport-app-state"})
public final class TodoListItemVm {
    @Nullable
    private final Ref<TodoItemRecord> ref;
    @Nullable
    private final TodoItemRecord optimistic;
    @NotNull
    private final TodoItemRecord record;
    @NotNull
    private final TodoAnchor anchor;
    @NotNull
    private final TodoItemCategory category;
    @NotNull
    private final String link;
    private final int sortingKey;
    @Nullable
    private final String extId;

    public TodoListItemVm(@Nullable Ref<TodoItemRecord> ref2, @Nullable TodoItemRecord optimistic) {
        this.ref = ref2;
        this.optimistic = optimistic;
        Ref<TodoItemRecord> ref3 = this.ref;
        if ((ref3 == null || (ref3 = RefResolveKt.resolve(ref3)) == null) && (ref3 = this.optimistic) == null) {
            throw new IllegalStateException("wrong TodoListItemVm".toString());
        }
        this.record = ref3;
        String string = this.record.getId();
        Object object = this.optimistic;
        if (object == null || (object = ((TodoItemRecord)object).getId()) == null) {
            object = this.record.getTemporaryId();
        }
        this.anchor = new TodoAnchor(string, (String)object);
        Triple<TodoItemCategory, String, Integer> res = TodoItemCategoryKt.calcCategoryAndLinkAndSortingKey(this.record);
        this.category = (TodoItemCategory)res.getFirst();
        this.link = (String)res.getSecond();
        this.sortingKey = ((Number)res.getThird()).intValue();
        TodoItemContent todoItemContent = this.record.getContent();
        TodoContent todoContent = todoItemContent instanceof TodoContent ? (TodoContent)todoItemContent : null;
        this.extId = todoContent != null ? todoContent.getExtId() : null;
    }

    @Nullable
    public final Ref<TodoItemRecord> getRef() {
        return this.ref;
    }

    @Nullable
    public final TodoItemRecord getOptimistic() {
        return this.optimistic;
    }

    @NotNull
    public final TodoItemRecord getRecord() {
        return this.record;
    }

    @NotNull
    public final TodoAnchor getAnchor() {
        return this.anchor;
    }

    @NotNull
    public final TodoItemCategory getCategory() {
        return this.category;
    }

    @NotNull
    public final String getLink() {
        return this.link;
    }

    public final int getSortingKey() {
        return this.sortingKey;
    }

    @Nullable
    public final String getExtId() {
        return this.extId;
    }

    public boolean equals(@Nullable Object other) {
        TodoListItemVm oth;
        if (this == other) {
            return true;
        }
        TodoListItemVm todoListItemVm = oth = other instanceof TodoListItemVm ? (TodoListItemVm)other : null;
        return Intrinsics.areEqual((Object)this.anchor, (Object)(todoListItemVm != null ? todoListItemVm.anchor : null)) && this.record.getStatus() == oth.record.getStatus() && Intrinsics.areEqual((Object)this.record.getContent(), (Object)oth.record.getContent());
    }

    public int hashCode() {
        return this.anchor.hashCode() + this.record.getStatus().hashCode() + this.record.getContent().hashCode();
    }
}

