/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.calendar;

import circlet.common.calendar.RecurrenceRule;
import circlet.common.calendar.RecurrenceRuleFreq;
import circlet.platform.api.ADateJvmKt;
import circlet.platform.api.KotlinXDateTime;
import circlet.platform.api.Weekday;
import circlet.platform.api.WeekdayFormat;
import circlet.platform.api.WorkingDaysKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a%\u0010\b\u001a\u00020\u0001*\u00020\t2\n\u0010\n\u001a\u00060\fj\u0002`\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001a\u0010\u0013\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\b\u001a\u00020\u000eH\u0002\u00a8\u0006\u0016"}, d2={"formatMinutesAsTime", "", "minutesOfDay", "", "formatMinutesAsDuration", "minutes", "precise", "", "format", "Lcirclet/common/calendar/RecurrenceRule;", "start", "Lcirclet/platform/api/ADateTime;", "Lcirclet/platform/api/KotlinXDateTime;", "weekdayFormat", "Lcirclet/platform/api/WeekdayFormat;", "(Lcirclet/common/calendar/RecurrenceRule;Lcirclet/platform/api/KotlinXDateTime;Lcirclet/platform/api/WeekdayFormat;)Ljava/lang/String;", "order", "freq", "Lcirclet/common/calendar/RecurrenceRuleFreq$MonthlyOnFirstWeekday;", "weekdaysText", "", "Lcirclet/platform/api/Weekday;", "spaceport-common"})
@SourceDebugExtension(value={"SMAP\nFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Format.kt\ncirclet/common/calendar/FormatKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1557#2:91\n1628#2,3:92\n827#2:95\n855#2,2:96\n*S KotlinDebug\n*F\n+ 1 Format.kt\ncirclet/common/calendar/FormatKt\n*L\n44#1:91\n44#1:92,3\n75#1:95\n75#1:96,2\n*E\n"})
public final class FormatKt {
    @NotNull
    public static final String formatMinutesAsTime(int minutesOfDay) {
        StringBuilder stringBuilder;
        StringBuilder $this$formatMinutesAsTime_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$formatMinutesAsTime_u24lambda_u240.append(StringsKt.padStart((String)String.valueOf(minutesOfDay / 60), (int)2, (char)'0'));
        $this$formatMinutesAsTime_u24lambda_u240.append(':');
        $this$formatMinutesAsTime_u24lambda_u240.append(StringsKt.padStart((String)String.valueOf(minutesOfDay % 60), (int)2, (char)'0'));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String formatMinutesAsDuration(int minutes, boolean precise) {
        if (precise) {
            return minutes < 60 ? minutes + " min" : (minutes % 60 == 0 ? minutes / 60 + " h" : minutes / 60 + " h " + minutes % 60 + " min");
        }
        return minutes < 60 ? minutes + " min" : (minutes < 1440 && minutes % 60 == 0 ? minutes / 60 + " h" : (minutes < 1440 ? minutes / 60 + " h " + minutes % 60 + " min" : (minutes < 10080 ? minutes / 1440 + " d" : minutes / 10080 + " w")));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String format(@NotNull RecurrenceRule $this$format, @NotNull KotlinXDateTime start2, @NotNull WeekdayFormat weekdayFormat) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$map$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$format, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)((Object)weekdayFormat), (String)"weekdayFormat");
        List res = new ArrayList();
        RecurrenceRuleFreq freq = $this$format.getFreq();
        if (freq instanceof RecurrenceRuleFreq.Daily) {
            bl = res.add(((RecurrenceRuleFreq.Daily)freq).getInterval() == 1 ? "daily" : "every " + ((RecurrenceRuleFreq.Daily)freq).getInterval() + " days");
        } else if (freq instanceof RecurrenceRuleFreq.Weekly) {
            Object object;
            res.add(((RecurrenceRuleFreq.Weekly)freq).getInterval() == 1 ? "weekly" : "every " + ((RecurrenceRuleFreq.Weekly)freq).getInterval() + " weeks");
            List list2 = res;
            int n = ((RecurrenceRuleFreq.Weekly)freq).getWeekdays().size();
            if (n == 0) {
                object = "";
            } else if (n == 1) {
                object = "on " + WorkingDaysKt.title((Weekday)((Object)CollectionsKt.single(((RecurrenceRuleFreq.Weekly)freq).getWeekdays())), weekdayFormat);
            } else if (n == WorkingDaysKt.getDefaultWorkingDays().size()) {
                Collection<Integer> collection;
                void $this$mapTo$iv$iv;
                Iterable iterable = ((RecurrenceRuleFreq.Weekly)freq).getWeekdays();
                Set<Integer> set = WorkingDaysKt.getDefaultWorkingDays();
                List list3 = list2;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Weekday weekday = (Weekday)((Object)item$iv$iv);
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.ordinal());
                }
                collection = (List)destination$iv$iv;
                list2 = list3;
                object = set.containsAll(collection) ? "on weekdays" : FormatKt.weekdaysText(((RecurrenceRuleFreq.Weekly)freq).getWeekdays(), weekdayFormat);
            } else {
                object = n == 7 ? "on all days" : FormatKt.weekdaysText(((RecurrenceRuleFreq.Weekly)freq).getWeekdays(), weekdayFormat);
            }
            bl = list2.add(object);
        } else if (freq instanceof RecurrenceRuleFreq.MonthlyOnStartDate) {
            res.add(((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval() == 1 ? "monthly" : "every " + ((RecurrenceRuleFreq.MonthlyOnStartDate)freq).getInterval() + " months");
            bl = res.add("on day " + ADateJvmKt.getDayOfMonth(start2));
        } else if (freq instanceof RecurrenceRuleFreq.MonthlyOnDate) {
            res.add(((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval() == 1 ? "monthly" : "every " + ((RecurrenceRuleFreq.MonthlyOnDate)freq).getInterval() + " months");
            bl = res.add("on day " + ((RecurrenceRuleFreq.MonthlyOnDate)freq).getDay());
        } else if (freq instanceof RecurrenceRuleFreq.MonthlyOnFirstWeekday) {
            res.add(((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval() == 1 ? "monthly" : "every " + ((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getInterval() + " months");
            bl = res.add("on " + FormatKt.order((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq) + " " + WorkingDaysKt.title(((RecurrenceRuleFreq.MonthlyOnFirstWeekday)freq).getWeekday(), weekdayFormat));
        } else if (freq instanceof RecurrenceRuleFreq.MonthlyOnLastWeekday) {
            res.add(((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval() == 1 ? "monthly" : "every " + ((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getInterval() + " months");
            bl = res.add("on last " + WorkingDaysKt.title(((RecurrenceRuleFreq.MonthlyOnLastWeekday)freq).getWeekday(), weekdayFormat));
        } else if (freq instanceof RecurrenceRuleFreq.Yearly) {
            bl = res.add(((RecurrenceRuleFreq.Yearly)freq).getInterval() == 1 ? "yearly" : "every " + ((RecurrenceRuleFreq.Yearly)freq).getInterval() + " years");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Iterable $this$filterNot$iv = res;
        boolean $i$f$filterNot = false;
        $this$map$iv = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (StringsKt.isBlank((CharSequence)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, null, (int)63, null);
    }

    public static /* synthetic */ String format$default(RecurrenceRule recurrenceRule, KotlinXDateTime kotlinXDateTime, WeekdayFormat weekdayFormat, int n, Object object) {
        if ((n & 2) != 0) {
            weekdayFormat = WeekdayFormat.LONG;
        }
        return FormatKt.format(recurrenceRule, kotlinXDateTime, weekdayFormat);
    }

    private static final String order(RecurrenceRuleFreq.MonthlyOnFirstWeekday freq) {
        Object object;
        int shift = freq.getShift() + 1;
        switch (shift) {
            case 1: {
                object = "the first";
                break;
            }
            case 2: {
                object = "the second";
                break;
            }
            case 3: {
                object = "the third";
                break;
            }
            case 4: {
                object = "the fourth";
                break;
            }
            case 5: {
                object = "the fifth";
                break;
            }
            default: {
                object = "the " + shift + "th";
            }
        }
        return object;
    }

    private static final String weekdaysText(List<? extends Weekday> $this$weekdaysText, WeekdayFormat format) {
        return "on " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast($this$weekdaysText, (int)1), null, null, null, (int)0, null, arg_0 -> FormatKt.weekdaysText$lambda$3(format, arg_0), (int)31, null) + " and " + WorkingDaysKt.title((Weekday)((Object)CollectionsKt.last($this$weekdaysText)), format);
    }

    private static final CharSequence weekdaysText$lambda$3(WeekdayFormat $format, Weekday it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$format), (String)"$format");
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return WorkingDaysKt.title(it, $format);
    }
}

