/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.ProjectIdentifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcirclet/client/api/ProjectIdentifierResolver;", "", "<init>", "()V", "keyPrefix", "", "idPrefix", "resolve", "Lcirclet/client/api/ProjectIdentifier;", "projectAsString", "spaceport-client-api"})
public final class ProjectIdentifierResolver {
    @NotNull
    public static final ProjectIdentifierResolver INSTANCE = new ProjectIdentifierResolver();
    @NotNull
    private static final String keyPrefix = "key:";
    @NotNull
    private static final String idPrefix = "id:";

    private ProjectIdentifierResolver() {
    }

    @NotNull
    public final ProjectIdentifier resolve(@NotNull String projectAsString) {
        ProjectIdentifier projectIdentifier;
        Intrinsics.checkNotNullParameter((Object)projectAsString, (String)"projectAsString");
        if (StringsKt.startsWith((String)projectAsString, (String)keyPrefix, (boolean)true)) {
            String string = projectAsString.substring(keyPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            projectIdentifier = new ProjectIdentifier.Key(((Object)StringsKt.trim((CharSequence)string)).toString());
        } else if (StringsKt.startsWith((String)projectAsString, (String)idPrefix, (boolean)true)) {
            String string = projectAsString.substring(idPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            projectIdentifier = new ProjectIdentifier.Id(((Object)StringsKt.trim((CharSequence)string)).toString());
        } else {
            projectIdentifier = new ProjectIdentifier.Id(projectAsString);
        }
        return projectIdentifier;
    }
}

