/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.ApplicationOrganizerDTO;
import circlet.client.api.ExternalUserOrganizerDTO;
import circlet.client.api.HiddenUserDTO;
import circlet.client.api.MeetingOrganizer;
import circlet.client.api.MeetingOrganizerDTO;
import circlet.client.api.MeetingOrigin;
import circlet.client.api.UserOrganizerDTO;
import circlet.client.api.apps.ES_App;
import circlet.platform.api.Ref;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\b\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"description", "", "Lcirclet/client/api/MeetingOrigin;", "PRIVATE_USER_EMAIL", "HIDDEN_DTO", "Lcirclet/client/api/HiddenUserDTO;", "toDTO", "Lcirclet/client/api/MeetingOrganizerDTO;", "Lcirclet/client/api/MeetingOrganizer;", "invalidMeetingOrganizer", "Lcirclet/client/api/MeetingOrganizer$ExternalUser;", "getInvalidMeetingOrganizer", "()Lcirclet/client/api/MeetingOrganizer$ExternalUser;", "isHidden", "", "spaceport-client-api"})
@SourceDebugExtension(value={"SMAP\nMeetings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Meetings.kt\ncirclet/client/api/MeetingsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class MeetingsKt {
    @NotNull
    public static final String PRIVATE_USER_EMAIL = "private_user@example.org";
    @NotNull
    private static final HiddenUserDTO HIDDEN_DTO = new HiddenUserDTO();
    @NotNull
    private static final MeetingOrganizer.ExternalUser invalidMeetingOrganizer = new MeetingOrganizer.ExternalUser("n/a");

    @NotNull
    public static final String description(@NotNull MeetingOrigin $this$description) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$description, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$description.ordinal()]) {
            case 1: {
                string = "User";
                break;
            }
            case 2: {
                string = "Google Calendar";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public static final MeetingOrganizerDTO toDTO(@NotNull MeetingOrganizer $this$toDTO) {
        MeetingOrganizerDTO meetingOrganizerDTO;
        Intrinsics.checkNotNullParameter((Object)$this$toDTO, (String)"<this>");
        MeetingOrganizer meetingOrganizer = $this$toDTO;
        if (meetingOrganizer instanceof MeetingOrganizer.User) {
            meetingOrganizerDTO = new UserOrganizerDTO(((MeetingOrganizer.User)$this$toDTO).getProfileRef().getId());
        } else if (meetingOrganizer instanceof MeetingOrganizer.ExternalUser) {
            meetingOrganizerDTO = new ExternalUserOrganizerDTO(((MeetingOrganizer.ExternalUser)$this$toDTO).getEmail());
        } else if (meetingOrganizer instanceof MeetingOrganizer.Application) {
            Ref<ES_App> ref2 = ((MeetingOrganizer.Application)$this$toDTO).getApplicationRef();
            if (ref2 != null) {
                Ref<ES_App> it = ref2;
                boolean bl = false;
                meetingOrganizerDTO = new ApplicationOrganizerDTO(it.getId());
            } else {
                meetingOrganizerDTO = new HiddenUserDTO();
            }
        } else if (Intrinsics.areEqual((Object)meetingOrganizer, (Object)MeetingOrganizer.HiddenUser.INSTANCE)) {
            meetingOrganizerDTO = HIDDEN_DTO;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return meetingOrganizerDTO;
    }

    @NotNull
    public static final MeetingOrganizer.ExternalUser getInvalidMeetingOrganizer() {
        return invalidMeetingOrganizer;
    }

    public static final boolean isHidden(@NotNull MeetingOrganizer $this$isHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$isHidden, (String)"<this>");
        return $this$isHidden instanceof MeetingOrganizer.HiddenUser || $this$isHidden instanceof MeetingOrganizer.ExternalUser && Intrinsics.areEqual((Object)((MeetingOrganizer.ExternalUser)$this$isHidden).getEmail(), (Object)PRIVATE_USER_EMAIL);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MeetingOrigin.values().length];
            try {
                nArray[MeetingOrigin.User.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MeetingOrigin.GoogleCalendar.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

