/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.CommonIssueFlags;
import circlet.client.api.ProjectIdentifier;
import circlet.platform.api.annotations.HttpApiDoc;
import circlet.platform.api.annotations.HttpApiIdentifier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import platform.common.ApiFlagAnnotation;

@HttpApiIdentifier
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcirclet/client/api/IssueIdentifier;", "", "<init>", "()V", "Id", "Key", "ExternalId", "Lcirclet/client/api/IssueIdentifier$ExternalId;", "Lcirclet/client/api/IssueIdentifier$Id;", "Lcirclet/client/api/IssueIdentifier$Key;", "spaceport-client-api"})
public abstract class IssueIdentifier {
    private IssueIdentifier() {
    }

    public /* synthetic */ IssueIdentifier(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @HttpApiIdentifier.Var
    @HttpApiDoc(doc="Identifies issue in Space that was earlier imported from an external system by external id provided during the import.")
    @ApiFlagAnnotation(cls=CommonIssueFlags.ExternalId.class)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcirclet/client/api/IssueIdentifier$ExternalId;", "Lcirclet/client/api/IssueIdentifier;", "project", "Lcirclet/client/api/ProjectIdentifier;", "externalId", "", "<init>", "(Lcirclet/client/api/ProjectIdentifier;Ljava/lang/String;)V", "getProject", "()Lcirclet/client/api/ProjectIdentifier;", "getExternalId", "()Ljava/lang/String;", "toString", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "spaceport-client-api"})
    public static final class ExternalId
    extends IssueIdentifier {
        @NotNull
        private final ProjectIdentifier project;
        @NotNull
        private final String externalId;

        public ExternalId(@NotNull ProjectIdentifier project2, @NotNull String externalId) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)externalId, (String)"externalId");
            super(null);
            this.project = project2;
            this.externalId = externalId;
        }

        @NotNull
        public final ProjectIdentifier getProject() {
            return this.project;
        }

        @NotNull
        public final String getExternalId() {
            return this.externalId;
        }

        @NotNull
        public String toString() {
            return "{project:" + this.project + ",externalId:" + this.externalId + "}";
        }

        @NotNull
        public final ProjectIdentifier component1() {
            return this.project;
        }

        @NotNull
        public final String component2() {
            return this.externalId;
        }

        @NotNull
        public final ExternalId copy(@NotNull ProjectIdentifier project2, @NotNull String externalId) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)externalId, (String)"externalId");
            return new ExternalId(project2, externalId);
        }

        public static /* synthetic */ ExternalId copy$default(ExternalId externalId, ProjectIdentifier projectIdentifier, String string, int n, Object object) {
            if ((n & 1) != 0) {
                projectIdentifier = externalId.project;
            }
            if ((n & 2) != 0) {
                string = externalId.externalId;
            }
            return externalId.copy(projectIdentifier, string);
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + this.externalId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExternalId)) {
                return false;
            }
            ExternalId externalId = (ExternalId)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)externalId.project)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.externalId, (Object)externalId.externalId);
        }
    }

    @HttpApiIdentifier.Var(prefixRequired=false)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0012\u0010\u000b\u001a\u00060\u0004j\u0002`\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0002\u001a\u00060\u0004j\u0002`\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcirclet/client/api/IssueIdentifier$Id;", "Lcirclet/client/api/IssueIdentifier;", "id", "Lcirclet/platform/api/TID;", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "Ljava/lang/String;", "toString", "component1", "copy", "(Ljava/lang/String;)Lcirclet/client/api/IssueIdentifier$Id;", "equals", "", "other", "", "hashCode", "", "spaceport-client-api"})
    public static final class Id
    extends IssueIdentifier {
        @NotNull
        private final String id;

        public Id(@NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            super(null);
            this.id = id2;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public String toString() {
            return "id:" + this.id;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final Id copy(@NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            return new Id(id2);
        }

        public static /* synthetic */ Id copy$default(Id id2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = id2.id;
            }
            return id2.copy(string);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Id)) {
                return false;
            }
            Id id2 = (Id)other;
            return Intrinsics.areEqual((Object)this.id, (Object)id2.id);
        }
    }

    @HttpApiIdentifier.Var
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcirclet/client/api/IssueIdentifier$Key;", "Lcirclet/client/api/IssueIdentifier;", "key", "", "<init>", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "spaceport-client-api"})
    public static final class Key
    extends IssueIdentifier {
        @NotNull
        private final String key;

        public Key(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(null);
            this.key = key;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public String toString() {
            return "key:" + this.key;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final Key copy(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new Key(key);
        }

        public static /* synthetic */ Key copy$default(Key key, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = key.key;
            }
            return key.copy(string);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            return Intrinsics.areEqual((Object)this.key, (Object)key.key);
        }
    }
}

