/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.AttachmentIn;
import circlet.client.api.FileIdentity;
import circlet.client.api.LinkIdentity;
import circlet.platform.api.serialization.ApiSerializable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.stringUtils.StringUtilsKt;

@ApiSerializable
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u00060\u0005j\u0002`\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0006\u0010\u0012\u001a\u00020\u0005J\u0012\u0010\u0013\u001a\u00060\u0005j\u0002`\u0004H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J0\u0010\u0016\u001a\u00020\u00002\f\b\u0002\u0010\u0003\u001a\u00060\u0005j\u0002`\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u0096\u0001J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0003\u001a\u00060\u0005j\u0002`\u0004X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006 "}, d2={"Lcirclet/client/api/FileAttachment;", "Lcirclet/client/api/AttachmentIn;", "Lcirclet/client/api/LinkIdentity;", "id", "Lcirclet/platform/api/TID;", "", "sizeBytes", "", "filename", "<init>", "(Ljava/lang/String;JLjava/lang/String;)V", "getId", "()Ljava/lang/String;", "Ljava/lang/String;", "getSizeBytes", "()J", "getFilename", "asText", "extension", "component1", "component2", "component3", "copy", "(Ljava/lang/String;JLjava/lang/String;)Lcirclet/client/api/FileAttachment;", "equals", "", "other", "", "hashCode", "", "identity", "toString", "spaceport-client-api"})
public final class FileAttachment
implements AttachmentIn,
LinkIdentity {
    private final /* synthetic */ FileIdentity $$delegate_0;
    @NotNull
    private final String id;
    private final long sizeBytes;
    @NotNull
    private final String filename;

    public FileAttachment(@NotNull String id2, long sizeBytes, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.$$delegate_0 = new FileIdentity(id2, filename);
        this.id = id2;
        this.sizeBytes = sizeBytes;
        this.filename = filename;
    }

    @Override
    @NotNull
    public String identity() {
        return this.$$delegate_0.identity();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public final long getSizeBytes() {
        return this.sizeBytes;
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    @Override
    @NotNull
    public String asText() {
        return "\ud83d\udcc4 " + StringUtilsKt.ellipsize(this.filename, 20);
    }

    @NotNull
    public final String extension() {
        String string = StringsKt.substringAfterLast((String)this.filename, (char)'.', (String)"").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.sizeBytes;
    }

    @NotNull
    public final String component3() {
        return this.filename;
    }

    @NotNull
    public final FileAttachment copy(@NotNull String id2, long sizeBytes, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return new FileAttachment(id2, sizeBytes, filename);
    }

    public static /* synthetic */ FileAttachment copy$default(FileAttachment fileAttachment, String string, long l, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = fileAttachment.id;
        }
        if ((n & 2) != 0) {
            l = fileAttachment.sizeBytes;
        }
        if ((n & 4) != 0) {
            string2 = fileAttachment.filename;
        }
        return fileAttachment.copy(string, l, string2);
    }

    @NotNull
    public String toString() {
        return "FileAttachment(id=" + this.id + ", sizeBytes=" + this.sizeBytes + ", filename=" + this.filename + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.sizeBytes);
        result2 = result2 * 31 + this.filename.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FileAttachment)) {
            return false;
        }
        FileAttachment fileAttachment = (FileAttachment)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)fileAttachment.id)) {
            return false;
        }
        if (this.sizeBytes != fileAttachment.sizeBytes) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.filename, (Object)fileAttachment.filename);
    }
}

