/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String myOriginalReason;
    @NotNull
    private final String[] myQuickFixes;
    private boolean myCauseInitialized;

    public ExternalSystemException() {
        this(null, (Throwable)null, new String[0]);
    }

    public ExternalSystemException(@Nullable String message) {
        this(message, (Throwable)null, new String[0]);
    }

    public ExternalSystemException(@Nullable Throwable cause) {
        this("", cause, new String[0]);
    }

    public ExternalSystemException(@Nullable String message, String ... quickFixes) {
        if (quickFixes == null) {
            ExternalSystemException.$$$reportNull$$$0(0);
        }
        this(message, (Throwable)null, quickFixes);
    }

    public ExternalSystemException(@Nullable String message, @Nullable Throwable cause, String ... quickFixes) {
        if (quickFixes == null) {
            ExternalSystemException.$$$reportNull$$$0(1);
        }
        super(ExternalSystemException.extractMessage(message, cause));
        this.myQuickFixes = ExternalSystemException.mergeArrays(cause instanceof ExternalSystemException ? ((ExternalSystemException)cause).getQuickFixes() : new String[]{}, quickFixes);
        if (cause == null) {
            this.myOriginalReason = "";
            return;
        }
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            cause.printStackTrace(printWriter);
        }
        this.myOriginalReason = stringWriter.toString();
    }

    @NotNull
    public String getOriginalReason() {
        String string = this.myOriginalReason;
        if (string == null) {
            ExternalSystemException.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String[] getQuickFixes() {
        if (this.myQuickFixes == null) {
            ExternalSystemException.$$$reportNull$$$0(3);
        }
        return this.myQuickFixes;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        s.println(this.myOriginalReason);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        s.println(this.myOriginalReason);
    }

    public synchronized boolean isCauseInitialized() {
        return this.myCauseInitialized;
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        this.myCauseInitialized = true;
        return super.initCause(cause);
    }

    @NotNull
    private static String extractMessage(@Nullable String message, @Nullable Throwable cause) {
        StringBuilder buffer = new StringBuilder();
        if (message != null) {
            buffer.append(message);
        }
        boolean first = true;
        for (Throwable t = cause; t != null; t = t.getCause()) {
            String m = t.getLocalizedMessage();
            if (m == null) continue;
            if (first) {
                first = false;
                if (m.equals(message)) {
                    continue;
                }
            } else if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append(m);
        }
        String string = buffer.toString();
        if (string == null) {
            ExternalSystemException.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static String[] mergeArrays(@NotNull String[] a1, @NotNull String[] a2) {
        if (a1 == null) {
            ExternalSystemException.$$$reportNull$$$0(5);
        }
        if (a2 == null) {
            ExternalSystemException.$$$reportNull$$$0(6);
        }
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/ExternalSystemException";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/ExternalSystemException";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalReason";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeArrays";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

