#!/bin/bash

set -exo pipefail

if ! [[ -t 1 && -t 2 ]]; then
	exec &> >(systemd-cat -t "$0")
fi

FLAG="/run/systemd-sleep/atop"

case "$1" in
pre)
	if systemctl is-active --quiet atop.service; then
		mkdir -p "${FLAG%%/*}"
		: > "$FLAG"
		systemctl stop atop.service
	fi
	;;
post)
	if [[ -e "$FLAG" ]]; then
		systemctl start atop.service
		rm -f "$FLAG"
	fi
	;;
*)
	exit 1
	;;
esac
