#
# Copyright (c) 2021-2025 ahriman team.
#
# This file is part of ahriman
# (see https://github.com/arcan1s/ahriman).
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#
from ahriman.core.distributed.distributed_system import DistributedSystem


class WorkerLoaderTrigger(DistributedSystem):
    """
    remote worker processor trigger (server side)
    """

    def on_start(self) -> None:
        """
        trigger action which will be called at the start of the application
        """
        if self.configuration.has_option("build", "workers"):
            return  # there is manually set option

        workers = [worker.address for worker in self.workers()]
        if not workers:
            return

        self.logger.info("load workers %s", workers)
        self.configuration.set_option("build", "workers", " ".join(workers))
