#!/usr/bin/bash
#
#   zipkmod.sh - Compress kernel modules
#
#   Copyright (c) 2024 Pacman Development Team <pacman-dev@lists.archlinux.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

[[ -n "$LIBMAKEPKG_TIDY_ZIPKMOD_SH" ]] && return
LIBMAKEPKG_TIDY_ZIPKMOD_SH=1

MAKEPKG_LIBRARY=${MAKEPKG_LIBRARY:-'/usr/share/makepkg'}

source "$MAKEPKG_LIBRARY/util/message.sh"
source "$MAKEPKG_LIBRARY/util/option.sh"

# XXX: hack: coexist with 50-zipkmod.sh from libmakepkg-dropins
if ! in_array tidy_zipkmod "${tidy_modify[@]}"; then
	packaging_options+=('zipkmod')
	tidy_modify+=('tidy_zipkmod')
fi

tidy_zipkmod() {
	if check_option "zipkmod" "y" && [[ -d "$PWD/usr/lib/modules" ]]; then
		msg2 "$(gettext "Compressing kernel modules...")"

		local zstd=(-"${KMOD_COMPRESSION_LEVEL:-19}")
		if (( KMOD_COMPRESSION_LEVEL > 19 )); then
			zstd+=(--ultra)
		fi

		# use external concurrency instead of zstd's internal concurrency
		# as the latter is less effective on small files
		find ./usr/lib/modules -type f -name '*.ko' -print0 \
			| xargs -0 -P "$(nproc)" -n 1 -- zstd "${zstd[@]}" --rm -f -q
	fi
}
